/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core;

import eu.ha3.matmos.core.MultistateComponent;
import eu.ha3.matmos.core.Provider;
import eu.ha3.matmos.core.ReferenceTime;
import eu.ha3.matmos.core.Simulated;
import eu.ha3.matmos.core.SoundRelay;
import eu.ha3.matmos.core.logic.Machine;

public class StreamInformation
extends MultistateComponent
implements Simulated {
    private String path;
    private float volume;
    private float pitch;
    private float delayBeforeFadeIn;
    private float delayBeforeFadeOut;
    private float fadeInTime;
    private float fadeOutTime;
    private boolean isLooping;
    private boolean usesPause;
    private boolean normalVolumeUnderwater;
    private final String machineName;
    private final Provider<Machine> provider;
    private final ReferenceTime time;
    private final SoundRelay relay;
    private int token;
    private long startTime;
    private long stopTime;

    public StreamInformation(String machineName, Provider<Machine> provider, ReferenceTime time, SoundRelay relay, String path, float volume, float pitch, float delayBeforeFadeIn, float delayBeforeFadeOut, float fadeInTime, float fadeOutTime, boolean isLooping, boolean usesPause, boolean underwater) {
        super("_STREAM:" + machineName);
        this.machineName = machineName;
        this.provider = provider;
        this.time = time;
        this.relay = relay;
        this.path = path;
        this.volume = volume;
        this.pitch = pitch;
        this.delayBeforeFadeIn = delayBeforeFadeIn;
        this.delayBeforeFadeOut = delayBeforeFadeOut;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
        this.isLooping = isLooping;
        this.usesPause = usesPause;
        this.normalVolumeUnderwater = underwater;
        this.token = relay.getStreamingTokenFor(path, volume, pitch, isLooping, usesPause, this.normalVolumeUnderwater);
    }

    @Override
    public void evaluate() {
        if (!this.provider.exists(this.machineName)) {
            return;
        }
        boolean active = this.provider.get(this.machineName).isActive();
        if (active != this.isActive) {
            this.isActive = active;
            this.incrementVersion();
            if (active) {
                this.signalPlayable();
            } else {
                this.signalStoppable();
            }
        }
    }

    private void signalPlayable() {
        this.startTime = this.time.getMilliseconds() + (long)(this.delayBeforeFadeIn * 1000.0f);
    }

    private void signalStoppable() {
        this.stopTime = this.time.getMilliseconds() + (long)(this.delayBeforeFadeOut * 1000.0f);
    }

    @Override
    public void simulate() {
        if (!this.isLooping && this.usesPause) {
            return;
        }
        if (this.isActive) {
            if (this.time.getMilliseconds() > this.startTime) {
                this.relay.setVolume(this.token, this.volume, this.fadeInTime);
            }
        } else if (!this.isActive && this.time.getMilliseconds() > this.stopTime) {
            this.relay.setVolume(this.token, 0.0f, this.fadeOutTime);
        }
    }
}

