/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.event;

import eu.ha3.matmos.core.MultistateComponent;
import eu.ha3.matmos.core.Provider;
import eu.ha3.matmos.core.ReferenceTime;
import eu.ha3.matmos.core.Simulated;
import eu.ha3.matmos.core.event.TimedEvent;
import eu.ha3.matmos.core.event.TimedEventInterface;
import eu.ha3.matmos.core.logic.Machine;
import eu.ha3.matmos.util.math.HelperFadeCalculator;
import java.util.List;

public class TimedEventInformation
extends MultistateComponent
implements Simulated {
    private float delayBeforeFadeIn = 0.0f;
    private float delayBeforeFadeOut = 0.0f;
    private float fadeInTime = 0.0f;
    private float fadeOutTime = 0.0f;
    private final String machineName;
    private final Provider<Machine> provider;
    private final ReferenceTime time;
    private List<TimedEvent> events;
    private HelperFadeCalculator calc;
    private boolean isPlaying;
    private long startTime;
    private long stopTime;

    public TimedEventInformation(String machineName, Provider<Machine> provider, ReferenceTime time, List<TimedEvent> events, float delayBeforeFadeIn, float delayBeforeFadeOut, float fadeInTime, float fadeOutTime) {
        super("_TIMED:" + machineName);
        this.machineName = machineName;
        this.provider = provider;
        this.time = time;
        this.calc = new HelperFadeCalculator(time);
        this.events = events;
        this.delayBeforeFadeIn = delayBeforeFadeIn;
        this.delayBeforeFadeOut = delayBeforeFadeOut;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
    }

    private void signalPlayable() {
        this.startTime = this.time.getMilliseconds() + (long)(this.delayBeforeFadeIn * 1000.0f);
    }

    private void signalStoppable() {
        this.stopTime = this.time.getMilliseconds() + (long)(this.delayBeforeFadeOut * 1000.0f);
    }

    @Override
    public void evaluate() {
        if (!this.provider.exists(this.machineName)) {
            return;
        }
        boolean active = this.provider.get(this.machineName).isActive();
        if (active != this.isActive) {
            this.isActive = active;
            this.incrementVersion();
            if (active) {
                this.signalPlayable();
            } else {
                this.signalStoppable();
            }
        }
    }

    @Override
    public void simulate() {
        if (this.isActive && !this.isPlaying) {
            if (this.time.getMilliseconds() > this.startTime) {
                this.isPlaying = true;
                this.calc.fadeIn((long)(this.fadeInTime * 1000.0f));
                for (TimedEventInterface timedEventInterface : this.events) {
                    timedEventInterface.restart(this.time);
                }
            }
        } else if (!this.isActive && this.isPlaying && this.time.getMilliseconds() > this.stopTime) {
            this.isPlaying = false;
            this.calc.fadeOut((long)(this.fadeOutTime * 1000.0f));
        }
        if (this.isPlaying || this.calc.calculateFadeFactor() > 0.0f) {
            this.play();
        }
    }

    private void play() {
        float fadeFactor = this.calc.calculateFadeFactor();
        for (TimedEventInterface timedEventInterface : this.events) {
            timedEventInterface.play(this.time, fadeFactor);
        }
    }
}

