/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.expansion;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.UpdatableIdentity;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.HaddonVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SoundpackIdentity
implements UpdatableIdentity {
    private final String type;
    private final int engineVersion;
    private final String name;
    private final String author;
    private final String website;
    private final String uniqueName;
    private final HaddonVersion version;
    private final String updateJson;

    public SoundpackIdentity(JsonObject matPackRoot) {
        SerialMatPack serial = (SerialMatPack)new Gson().fromJson((JsonElement)matPackRoot, SerialMatPack.class);
        this.type = serial.type;
        this.engineVersion = serial.engineversion;
        this.name = serial.metadata != null ? serial.metadata.name : null;
        this.author = serial.metadata != null ? serial.metadata.author : null;
        this.website = serial.metadata != null ? serial.metadata.website : null;
        this.uniqueName = serial.uniquename;
        this.version = serial.version != null ? new HaddonVersion(serial.version) : null;
        this.updateJson = serial.updatejson;
    }

    @Override
    public String getHaddonName() {
        return this.name;
    }

    @Override
    public HaddonVersion getHaddonVersion() {
        return this.version;
    }

    @Override
    public String getHaddonMinecraftVersion() {
        return "";
    }

    @Override
    public String getHaddonAddress() {
        return this.website;
    }

    @Override
    public String getHaddonHumanVersion() {
        return this.getHaddonVersion().toString();
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public List<String> getUpdateURLs() {
        return new ArrayList<String>(Arrays.asList(this.updateJson));
    }

    public boolean equals(Object obj) {
        if (obj instanceof SoundpackIdentity) {
            SoundpackIdentity o = (SoundpackIdentity)obj;
            return Objects.equals(this.type, o.type) && Objects.equals(this.engineVersion, o.engineVersion) && Objects.equals(this.name, o.name) && Objects.equals(this.author, o.author) && Objects.equals(this.website, o.website) && Objects.equals(this.uniqueName, o.uniqueName) && Objects.equals(this.version, o.version) && Objects.equals(this.updateJson, o.updateJson);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.engineVersion, this.name, this.author, this.website, this.uniqueName, this.version, this.updateJson);
    }

    @Override
    public String getPlatformName() {
        return "MAtmos";
    }

    @Override
    public HaddonVersion getPlatformVersion() {
        return new HaddonVersion(Matmos.identity.getHaddonVersion().getMajorVersion());
    }

    public static class SerialMatPackMetadata {
        String name;
        String author;
        String website;
    }

    public static class SerialMatPack {
        String type;
        int engineversion;
        SerialMatPackMetadata metadata;
        String uniquename;
        String version;
        String updatejson;
    }
}

