/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.logic;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Dependable;
import eu.ha3.matmos.core.MultistateComponent;
import eu.ha3.matmos.core.Provider;
import eu.ha3.matmos.core.Simulated;
import eu.ha3.matmos.core.StreamInformation;
import eu.ha3.matmos.core.event.TimedEventInformation;
import eu.ha3.matmos.core.logic.Junction;
import eu.ha3.matmos.core.logic.Overrided;
import eu.ha3.matmos.core.logic.VisualizedSpecialDependencies;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Machine
extends MultistateComponent
implements Dependable,
Simulated,
Overrided,
VisualizedSpecialDependencies {
    private final List<String> allow;
    private final List<String> restrict;
    private final TimedEventInformation timed;
    private final List<StreamInformation> streams;
    private final Provider<Junction> provider;
    private boolean overrideUnderway;
    private boolean overrideState;
    private final Collection<String> dependencies;

    public Machine(String name, Provider<Junction> provider, List<String> allow, List<String> restrict, TimedEventInformation timed, List<StreamInformation> streams) {
        super(name);
        this.provider = provider;
        this.allow = allow;
        this.restrict = restrict;
        this.timed = timed;
        this.streams = streams;
        this.dependencies = new TreeSet<String>();
        this.dependencies.addAll(allow);
        this.dependencies.addAll(restrict);
    }

    @Override
    public void simulate() {
        if (this.timed != null) {
            this.timed.simulate();
        }
        for (StreamInformation stream : this.streams) {
            stream.simulate();
        }
    }

    @Override
    public void evaluate() {
        boolean previous = this.isActive;
        this.isActive = this.testIfTrue();
        if (previous != this.isActive) {
            this.incrementVersion();
            if (this.timed != null) {
                this.timed.evaluate();
            }
            for (StreamInformation stream : this.streams) {
                stream.evaluate();
            }
            Matmos.DEBUGLOGGER.debug("M: " + this.getName() + " -> " + this.isActive);
        }
    }

    private boolean testIfTrue() {
        if (this.overrideUnderway) {
            return this.overrideState;
        }
        boolean isTrue = false;
        Iterator<String> iterAllow = this.allow.iterator();
        while (!isTrue && iterAllow.hasNext()) {
            String junction = iterAllow.next();
            if (!this.provider.exists(junction) || !this.provider.get(junction).isActive()) continue;
            isTrue = true;
        }
        if (!isTrue) {
            return false;
        }
        Iterator<String> iterRestrict = this.restrict.iterator();
        while (isTrue && iterRestrict.hasNext()) {
            String junction = iterRestrict.next();
            if (!this.provider.exists(junction) || !this.provider.get(junction).isActive()) continue;
            isTrue = false;
        }
        return isTrue;
    }

    @Override
    public void overrideForceOn() {
        this.overrideUnderway = true;
        this.overrideState = true;
        this.evaluate();
    }

    @Override
    public void overrideForceOff() {
        this.overrideUnderway = true;
        this.overrideState = false;
        this.evaluate();
    }

    @Override
    public void overrideFinish() {
        this.overrideUnderway = false;
        this.evaluate();
    }

    @Override
    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getFeed() {
        return "";
    }

    @Override
    public Collection<String> getSpecialDependencies(String type) {
        if (type.equals("allow")) {
            return this.allow;
        }
        if (type.equals("restrict")) {
            return this.restrict;
        }
        return new HashSet<String>();
    }
}

