/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.preinit;

import eu.ha3.matmos.ConfigManager;
import eu.ha3.matmos.core.preinit.SoundSystemReplacerTransformer;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.ConfigProperty;
import eu.ha3.matmos.util.VersionDependentConstants;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundSystemReplacer {
    public static final Logger logger = LogManager.getLogger((String)"matmos-preinit");
    public static ConfigProperty preinitConfig;

    private static List<String> findModsWithConflicts() {
        ArrayList<String> conflicts = new ArrayList<String>();
        for (Pair<String, String> conflict : VersionDependentConstants.SOUND_SYSTEM_REPLACER_CONFLICTS) {
            if (Launch.classLoader.getResource((String)conflict.getRight()) == null) continue;
            conflicts.add((String)conflict.getLeft());
        }
        return conflicts;
    }

    public static void run() {
        String option = ConfigManager.getConfig().getString("coremod.replacesoundsystem");
        boolean shouldReplace = false;
        switch (option) {
            case "always": {
                shouldReplace = true;
                break;
            }
            case "auto": {
                List<String> conflicts = SoundSystemReplacer.findModsWithConflicts();
                if (!conflicts.isEmpty()) {
                    logger.info("SoundSystem won't be replaced, because these conflicting mods were found: " + conflicts);
                    break;
                }
                shouldReplace = true;
                break;
            }
            case "never": {
                logger.info("SoundSystem won't be replaced, because it was disabled in the config.");
            }
        }
        if (shouldReplace) {
            logger.info("Initializing SoundSystem replacer transformer");
            URL packageURL = SoundSystemReplacer.class.getClassLoader().getResource("eu/ha3/matmos");
            if (packageURL == null) {
                logger.info("Couldn't find eu.ha3.matmos package in MAtmos jar. SoundSystem will not be overloaded.");
            } else {
                logger.debug("Resolving base jar URL from " + packageURL);
                URL baseJarURL = SoundSystemReplacer.getBaseJarURL(packageURL);
                if (baseJarURL != null) {
                    logger.debug("Resolved base jar URL to " + baseJarURL);
                    try {
                        LaunchClassLoader lcl = Launch.classLoader;
                        Field transformersField = LaunchClassLoader.class.getDeclaredField("transformers");
                        transformersField.setAccessible(true);
                        List transformers = (List)transformersField.get(lcl);
                        transformers.add(0, new SoundSystemReplacerTransformer(baseJarURL));
                        logger.info("Finished initializing SoundSystem replacer transformer");
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        logger.warn("Exception registering SoundSystem replacer transformer. SoundSystem will not be overloaded.");
                        e.printStackTrace();
                    }
                } else {
                    logger.warn("Failed to extract base jar url from " + packageURL + ". SoundSystem will not be overloaded.");
                }
            }
        }
    }

    public static URL getBaseJarURL(URL packageURL) {
        String newURLString = null;
        switch (packageURL.getProtocol()) {
            case "jar": {
                String urlString = packageURL.getPath();
                int lastExclamation = urlString.lastIndexOf(33);
                newURLString = urlString.substring(0, lastExclamation);
                break;
            }
            default: {
                logger.info("The path to " + packageURL + " isn't in a jar; we're probably in a dev environment. You'll have to manually configure your dev environment if you want to override the SoundSystem.");
            }
        }
        if (newURLString != null) {
            try {
                return new URL(newURLString);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

