/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.preinit;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundSystemReplacerTransformer
implements IClassTransformer {
    private static final Logger logger = LogManager.getLogger((String)"matmos-preinit");
    Map<String, byte[]> classData;
    private static boolean hasMadeChanges;

    public SoundSystemReplacerTransformer(URL baseJarURL) {
        this.classData = this.readClassesFrom(baseJarURL);
    }

    private Map<String, byte[]> readClassesFrom(URL baseJarURL) {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        try (ZipFile zipFile = new ZipFile(new File(baseJarURL.toURI()));){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("paulscode/") || !entry.getName().endsWith(".class")) continue;
                InputStream is = zipFile.getInputStream(entry);
                byte[] buf = IOUtils.toByteArray((InputStream)is);
                IOUtils.closeQuietly((Closeable)is);
                if (entry.getSize() != (long)buf.length) {
                    logger.warn("Class " + entry.getName() + " has a wrong size: " + buf.length + " (expected " + entry.getSize() + ")");
                }
                String className = entry.getName().substring(0, entry.getName().length() - 6).replaceAll("/", ".");
                data.put(className, buf);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return data;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.startsWith("paulscode.")) {
            Optional<byte[]> newData = this.loadOverridenClass(name, transformedName);
            if (newData.isPresent()) {
                hasMadeChanges = true;
            }
            return newData.orElse(basicClass);
        }
        return basicClass;
    }

    private Optional<byte[]> loadOverridenClass(String name, String transformedName) {
        return Optional.ofNullable(this.classData.get(name));
    }

    public static boolean hasMadeChanges() {
        return hasMadeChanges;
    }
}

