/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sfx;

import eu.ha3.matmos.core.Named;
import eu.ha3.matmos.core.SoundRelay;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.event.BlockChangeEvent;
import eu.ha3.matmos.util.MAtUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;

public class BlockChangeSound
implements Named {
    private String name;
    private final SoundRelay relay;
    private boolean onPlace;
    private boolean onBreak;
    private List<Integer> blockIDs = new LinkedList<Integer>();
    private String sound;
    private float volMin;
    private float volMax;
    private float pitchMin;
    private float pitchMax;

    public BlockChangeSound(String name, SoundRelay relay, List<String> when, List<String> blocks, String sound, float volMin, float volMax, float pitchMin, float pitchMax) {
        this.name = name;
        this.relay = relay;
        this.onPlace = when.contains("onplace");
        this.onBreak = when.contains("onbreak");
        this.pitchMin = pitchMin;
        this.pitchMax = pitchMax;
        this.volMin = volMin;
        this.volMax = volMax;
        blocks.forEach(b -> {
            if (MAtUtil.blockRegistryContains(b)) {
                this.blockIDs.add(Block.func_149682_b((Block)MAtUtil.blockRegistryGet(b)));
            }
        });
        this.sound = sound;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void onBlockChange(BlockChangeEvent e) {
        int brokeID;
        int placedID;
        boolean accept = false;
        if (this.onPlace && e.oldBlock instanceof BlockAir && this.blockIDs.contains(placedID = Block.func_149682_b((Block)e.newBlock))) {
            accept = true;
        }
        if (this.onBreak && e.newBlock instanceof BlockAir && this.blockIDs.contains(brokeID = Block.func_149682_b((Block)e.oldBlock))) {
            accept = true;
        }
        if (accept) {
            this.play(e.x, e.y, e.z);
        }
    }

    public void play(int x, int y, int z) {
        this.relay.playSoundEvent(this.sound, x, y, z, MAtUtil.randomFloatRange(this.volMin, this.volMax), MAtUtil.randomFloatRange(this.pitchMin, this.pitchMax));
    }
}

