/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.data.modules.AbstractThingCountModule;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStringCountModule
extends AbstractThingCountModule<String> {
    private Set<String> oldThings = new LinkedHashSet<String>();
    private Set<String> newThings = new LinkedHashSet<String>();
    protected Map<String, Integer> things = new HashMap<String, Integer>();

    public AbstractStringCountModule(DataPackage data, String name) {
        this(data, name, false);
    }

    public AbstractStringCountModule(DataPackage data, String name, boolean doNotUseDelta) {
        super(data, name, doNotUseDelta);
        data.getSheet(name).setDefaultValue("0");
        if (!doNotUseDelta) {
            data.getSheet(name + "_delta").setDefaultValue("0");
        }
    }

    @Override
    protected void doProcess() {
        this.count();
        this.apply();
    }

    @Override
    public void increment(String thing) {
        this.increment(thing, 1);
    }

    @Override
    public void increment(String thing, int amount) {
        this.things.put(thing, this.things.containsKey(thing) ? this.things.get(thing) + amount : amount);
    }

    @Override
    public int get(String thing) {
        return this.things.get(thing);
    }

    @Override
    protected abstract void count();

    @Override
    public void apply() {
        for (Map.Entry<String, Integer> entry : this.things.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue().intValue());
        }
        this.newThings.addAll(this.things.keySet());
        this.things.clear();
        this.oldThings.removeAll(this.newThings);
        for (String missing : this.oldThings) {
            this.setValue(missing, 0L);
        }
        this.oldThings.clear();
        Set<String> anEmptySet = this.oldThings;
        this.oldThings = this.newThings;
        this.newThings = anEmptySet;
    }
}

