/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.data.IDataCollector;
import eu.ha3.matmos.data.IDataGatherer;
import eu.ha3.matmos.data.modules.ModuleProcessor;
import eu.ha3.matmos.data.modules.PassOnceModule;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class ModuleEntity
implements IDataGatherer,
PassOnceModule {
    private final Set<String> submodules;
    private final IDataCollector collector;
    private AxisAlignedBB bbox;
    private ModuleProcessor mindistModel;
    private Map<String, Double> minimumDistanceReports;
    private ModuleProcessor[] radiusSheets;
    private int[] radiusValuesSorted;
    private Map<String, Integer>[] entityCount;
    private int maxel;
    private boolean isRequired;

    public ModuleEntity(DataPackage dataIn, IDataCollector collector, String minDistModule, String radiModulePrefix, int max, int ... radiis) {
        this.collector = collector;
        this.submodules = new LinkedHashSet<String>();
        this.mindistModel = new ModuleProcessor(dataIn, minDistModule){

            @Override
            protected void doProcess() {
            }
        };
        dataIn.getSheet(minDistModule).setDefaultValue("0");
        this.submodules.add(minDistModule);
        this.minimumDistanceReports = new HashMap<String, Double>();
        this.radiusSheets = new ModuleProcessor[radiis.length];
        this.entityCount = new Map[radiis.length];
        this.radiusValuesSorted = Arrays.copyOf(radiis, radiis.length);
        Arrays.sort(this.radiusValuesSorted);
        this.maxel = this.radiusValuesSorted[this.radiusValuesSorted.length - 1] + 10;
        for (int i = 0; i < this.radiusValuesSorted.length; ++i) {
            int radiNum = this.radiusValuesSorted[i];
            this.radiusSheets[i] = new ModuleProcessor(dataIn, radiModulePrefix + radiNum){

                @Override
                protected void doProcess() {
                }
            };
            dataIn.getSheet(radiModulePrefix + radiNum).setDefaultValue(Integer.toString(Integer.MAX_VALUE));
            this.submodules.add(radiModulePrefix + radiNum);
            this.entityCount[i] = new HashMap<String, Integer>();
        }
        this.bbox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    private void refresh() {
        this.isRequired = false;
        this.isRequired = this.collector.requires(this.mindistModel.getName());
        for (ModuleProcessor processor : this.radiusSheets) {
            this.isRequired = this.isRequired || this.collector.requires(processor.getName());
        }
        for (Map<String, Integer> mappy : this.entityCount) {
            mappy.clear();
        }
        for (String type : this.minimumDistanceReports.keySet()) {
            for (int i = 0; i < this.radiusValuesSorted.length; ++i) {
                this.radiusSheets[i].setValue(type, 0L);
            }
            this.mindistModel.setValue(type, Integer.MAX_VALUE);
        }
        this.minimumDistanceReports.clear();
    }

    @Override
    public void process() {
        this.refresh();
        if (!this.isRequired) {
            IDontKnowHowToCode.warnOnce("EntityDetector is running but not required. Logic error?");
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        double x = mc.field_71439_g.field_70165_t;
        double y = mc.field_71439_g.field_70163_u;
        double z = mc.field_71439_g.field_70161_v;
        this.bbox = new AxisAlignedBB(x - (double)this.maxel, y - (double)this.maxel, z - (double)this.maxel, x + (double)this.maxel, y + (double)this.maxel, z + (double)this.maxel);
        List entityList = mc.field_71441_e.func_72872_a(Entity.class, this.bbox);
        for (Object e : entityList) {
            if (e == null || e == mc.field_71439_g) continue;
            double dx = ((Entity)e).field_70165_t - x;
            double dy = ((Entity)e).field_70163_u - y;
            double dz = ((Entity)e).field_70161_v - z;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (e instanceof EntityPlayer) {
                this.reportDistance("minecraft:player", distance);
            } else {
                ResourceLocation eID = EntityList.func_191301_a((Entity)e);
                if (eID != null) {
                    this.reportDistance(eID.toString(), distance);
                }
            }
            int i = 0;
            boolean reported = false;
            while (i < this.radiusValuesSorted.length && !reported) {
                if (distance <= (double)this.radiusValuesSorted[i]) {
                    ResourceLocation eID;
                    if (!(e instanceof EntityPlayer) && (eID = EntityList.func_191301_a((Entity)e)) != null) {
                        for (int above = i; above < this.radiusValuesSorted.length; ++above) {
                            this.addToEntityCount(above, eID.toString(), 1);
                        }
                    }
                    reported = true;
                    continue;
                }
                ++i;
            }
        }
        for (int i = 0; i < this.radiusValuesSorted.length; ++i) {
            if (!this.collector.requires(this.radiusSheets[i].getName())) continue;
            for (String entityID : this.entityCount[i].keySet()) {
                this.radiusSheets[i].setValue(entityID, this.entityCount[i].get(entityID).intValue());
            }
        }
        if (this.collector.requires(this.mindistModel.getName())) {
            for (String entityID : this.minimumDistanceReports.keySet()) {
                this.mindistModel.setValue(entityID, (int)Math.floor(this.minimumDistanceReports.get(entityID) * 1000.0));
            }
        }
        if (this.collector.requires(this.mindistModel.getName())) {
            this.mindistModel.process();
        }
        for (int i = 0; i < this.radiusValuesSorted.length; ++i) {
            if (!this.collector.requires(this.radiusSheets[i].getName())) continue;
            this.radiusSheets[i].process();
        }
    }

    protected void addToEntityCount(int radiIndex, String entityID, int count) {
        if (this.entityCount[radiIndex].containsKey(entityID)) {
            this.entityCount[radiIndex].put(entityID, this.entityCount[radiIndex].get(entityID) + count);
        } else {
            this.entityCount[radiIndex].put(entityID, count);
        }
    }

    protected void reportDistance(String type, double distance) {
        if (!this.minimumDistanceReports.containsKey(type) || this.minimumDistanceReports.get(type) > distance) {
            this.minimumDistanceReports.put(type, distance);
        }
    }

    @Override
    public String getName() {
        return "_POM__entity_detector";
    }

    @Override
    public Set<String> getSubModules() {
        return this.submodules;
    }
}

