/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.data.modules.Module;
import eu.ha3.matmos.data.modules.ModuleProcessor;
import eu.ha3.matmos.util.MAtUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import net.minecraft.client.multiplayer.ServerData;

public class ModuleServerInfo
extends ModuleProcessor
implements Module {
    private final Map<String, Integer> serverAddresses = new HashMap<String, Integer>();
    private final Map<String, Integer> serverPorts = new HashMap<String, Integer>();

    public ModuleServerInfo(DataPackage data) {
        super(data, "server_info", true);
    }

    @Override
    protected void doProcess() {
        ServerData serverData = MAtUtil.getCurrentServerData();
        if (serverData != null && serverData.field_78845_b != null) {
            String playerDefinedAddress = serverData.field_78845_b;
            this.queryActualIP_useCache(playerDefinedAddress);
            String MOTDsec = serverData.field_78843_d;
            String NAMEsec = serverData.field_78847_a;
            if (MOTDsec == null) {
                MOTDsec = "";
            }
            if (NAMEsec == null) {
                NAMEsec = "";
            }
            this.setValue("has_server_info", true);
            this.setValue("addressinput_hashcode", serverData.field_78845_b.toLowerCase(Locale.ENGLISH).hashCode());
            this.setValue("motd_hashcode", MOTDsec.hashCode());
            this.setValue("name_hashcode", NAMEsec.hashCode());
            this.setValue("ip_computed_hashcode", this.serverAddresses.get(playerDefinedAddress).intValue());
            this.setValue("port_computed", this.serverPorts.get(playerDefinedAddress).intValue());
        } else {
            this.setValue("has_server_info", false);
            this.setValue("addressinput_hashcode", "");
            this.setValue("motd_hashcode", "");
            this.setValue("name_hashcode", "");
            this.setValue("ip_computed_hashcode", "");
            this.setValue("port_computed", "");
        }
    }

    private void queryActualIP_useCache(String playerDefinedAddress) {
        int portPotential;
        int vDelimiter;
        if (this.serverAddresses.containsKey(playerDefinedAddress)) {
            return;
        }
        String[] splitIp = playerDefinedAddress.split(":");
        if (playerDefinedAddress.charAt(0) == '[' && (vDelimiter = playerDefinedAddress.indexOf("]")) > 0) {
            String ipPart = playerDefinedAddress.substring(1, vDelimiter);
            String portPart = playerDefinedAddress.substring(vDelimiter + 1).trim();
            if (portPart.charAt(0) == ':' && portPart.length() > 0) {
                portPart = portPart.substring(1);
                splitIp = new String[]{ipPart, portPart};
            } else {
                splitIp = new String[]{ipPart};
            }
        }
        if (splitIp.length > 2) {
            splitIp = new String[]{playerDefinedAddress};
        }
        String ipPotential = splitIp[0];
        int n = portPotential = splitIp.length > 1 ? ModuleServerInfo.parseIntWithDefault(splitIp[1], 25565) : 25565;
        if (portPotential == 25565) {
            String[] var7 = ModuleServerInfo.resolveSRV(ipPotential);
            ipPotential = var7[0];
            portPotential = ModuleServerInfo.parseIntWithDefault(var7[1], 25565);
        }
        String conIp = ipPotential;
        int conPort = portPotential;
        String wellIp = "";
        int wellHashCode = 0;
        try {
            wellIp = InetAddress.getByName(conIp).getHostAddress();
            wellHashCode = wellIp.hashCode();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            this.serverAddresses.put(playerDefinedAddress, 0);
            this.serverPorts.put(playerDefinedAddress, conPort);
            Matmos.LOGGER.info("Error while hashing server addess: Defaulted to 0");
            return;
        }
        this.serverAddresses.put(playerDefinedAddress, wellHashCode);
        this.serverPorts.put(playerDefinedAddress, conPort);
        Matmos.LOGGER.info("Computed server IP and hashed as (" + wellHashCode + ") : " + conPort);
    }

    private static String[] resolveSRV(String resolve) {
        try {
            Hashtable<String, String> hash = new Hashtable<String, String>();
            hash.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            hash.put("java.naming.provider.url", "dns:");
            InitialDirContext idc = new InitialDirContext(hash);
            Attributes att = idc.getAttributes("_minecraft._tcp." + resolve, new String[]{"SRV"});
            String[] cts = att.get("srv").get().toString().split(" ", 4);
            return new String[]{cts[3], cts[2]};
        }
        catch (Throwable e) {
            return new String[]{resolve, Integer.toString(25565)};
        }
    }

    private static int parseIntWithDefault(String integer, int def) {
        try {
            return Integer.parseInt(integer.trim());
        }
        catch (Exception var3) {
            return def;
        }
    }
}

