/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.data.modules.Module;
import eu.ha3.matmos.data.modules.ModuleProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class ModuleTimedRandom
extends ModuleProcessor
implements Module {
    private static final Random RANDOM = new Random();
    private final List<TimedValue> timedRandoms = new ArrayList<TimedValue>();

    public ModuleTimedRandom(DataPackage data) {
        super(data, "timed_random");
        this.timedRandoms.addAll(Arrays.asList(new TimedValue(1), new TimedValue(2), new TimedValue(5), new TimedValue(10), new TimedValue(15), new TimedValue(20), new TimedValue(30), new TimedValue(60), new TimedValue(120), new TimedValue(300), new TimedValue(600), new TimedValue(1200)));
    }

    @Override
    protected void doProcess() {
        for (TimedValue timedRandom : this.timedRandoms) {
            timedRandom.process(this);
        }
    }

    private static class TimedValue {
        private final String playlistId;
        private final long period;
        private int activeValue = -1;
        private long endTime;

        public TimedValue(int secs) {
            int minutes = secs / 60;
            int secRemainder = secs % 60;
            this.playlistId = "timed_random" + (secRemainder == 0 ? String.format("_%02dminutes", minutes) : String.format("_%02dm%02ds", minutes, secRemainder));
            this.period = 1000 * secs;
        }

        public void process(ModuleTimedRandom timedRandom) {
            if (this.activeValue != -1) {
                if (this.endTime < System.currentTimeMillis()) {
                    this.activeValue = RANDOM.nextInt(100);
                    this.endTime = System.currentTimeMillis() + this.period;
                    timedRandom.setValue(this.playlistId, this.activeValue);
                }
            } else {
                this.activeValue = RANDOM.nextInt(100);
            }
        }
    }
}

