/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.DeltaSheet;
import eu.ha3.matmos.core.sheet.Sheet;
import eu.ha3.matmos.core.sheet.VirtualSheet;
import eu.ha3.matmos.data.IDataGatherer;

public abstract class ProcessorModel
implements IDataGatherer {
    protected Sheet sheet;
    private int interval;
    private int callsRemaining;

    public ProcessorModel(DataPackage data, String normalName, String deltaName) {
        this.sheet = deltaName == null ? data.getSheet(normalName) : new DeltaSheet(data, normalName, deltaName);
        this.interval = 1;
        this.callsRemaining = 0;
    }

    protected abstract void doProcess();

    @Override
    public void process() {
        if (this.callsRemaining <= 0) {
            this.doProcess();
            if (this.sheet instanceof VirtualSheet) {
                ((VirtualSheet)this.sheet).apply();
            }
            if (this.interval != 0) {
                this.callsRemaining = this.interval;
            }
        } else {
            --this.callsRemaining;
        }
    }

    public void setInterval(int value) {
        this.interval = Math.min(0, value);
        this.callsRemaining = 0;
    }

    public void setValueIntIndex(int index, boolean value) {
        this.setValue(Integer.toString(index), value);
    }

    public void setValueIntIndex(int index, long value) {
        this.setValue(Integer.toString(index), value);
    }

    public void setValueIntIndex(int index, String value) {
        this.setValue(Integer.toString(index), value);
    }

    public void setValue(String index, boolean newValue) {
        this.setValue(index, newValue ? "1" : "0");
    }

    public void setValue(String index, long newValue) {
        this.setValue(index, Long.toString(newValue));
    }

    public void setValue(String index, String value) {
        this.sheet.set(index, value == null ? "NULL" : value);
    }
}

