/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules.items;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.data.modules.ModuleProcessor;
import eu.ha3.matmos.data.modules.RegistryBasedModule;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import eu.ha3.matmos.util.MAtUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.potion.PotionEffect;

abstract class AbstractPotionQualityModule
extends ModuleProcessor
implements RegistryBasedModule {
    private Set<String> oldThings = new LinkedHashSet<String>();

    public AbstractPotionQualityModule(DataPackage data, String name) {
        super(data, name);
        data.getSheet(name).setDefaultValue("0");
        data.getSheet(name + "_delta").setDefaultValue("0");
    }

    @Override
    public String getRegistryName() {
        return "potion";
    }

    @Override
    protected void doProcess() {
        for (String i : this.oldThings) {
            this.setValue(i, 0L);
        }
        this.oldThings.clear();
        for (String effectObj : this.getPlayer().func_70651_bq()) {
            if (effectObj instanceof PotionEffect) {
                PotionEffect effect = (PotionEffect)effectObj;
                int id = MAtUtil.getPotionEffectID(effect);
                this.setValue(Integer.toString(id), this.getQuality(effect));
                this.oldThings.add(Integer.toString(id));
                continue;
            }
            IDontKnowHowToCode.warnOnce("getActivePotionEffects() contained a " + effectObj.getClass() + ", (" + effectObj + "), expected PotionEffect");
        }
    }

    protected abstract String getQuality(PotionEffect var1);
}

