/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.scanners;

import eu.ha3.matmos.data.scanners.Progress;
import eu.ha3.matmos.data.scanners.ScanOperations;

public abstract class Scan
implements Progress {
    protected ScanOperations pipeline = null;
    protected int opspercall;
    protected boolean isScanning = false;
    protected int finalProgress = 1;
    protected int progress = 1;

    public void setPipeline(ScanOperations pipelineIn) {
        this.pipeline = pipelineIn;
    }

    protected void startScan(int x, int y, int z, int xsizeIn, int ysizeIn, int zsizeIn, int opspercallIn) {
        if (this.isScanning) {
            return;
        }
        if (this.pipeline == null) {
            return;
        }
        if (opspercallIn <= 0) {
            throw new IllegalArgumentException();
        }
        this.opspercall = opspercallIn;
        this.progress = 0;
        this.finalProgress = 1;
        this.initScan(x, y, z, xsizeIn, ysizeIn, zsizeIn, opspercallIn);
        this.pipeline.begin();
        this.isScanning = true;
    }

    abstract void initScan(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public boolean routine() {
        if (!this.isScanning) {
            return false;
        }
        boolean result = this.doRoutine();
        if (this.progress >= this.finalProgress) {
            this.scanDoneEvent();
        }
        return result;
    }

    protected abstract boolean doRoutine();

    @Override
    public int getProgress_Current() {
        return this.progress;
    }

    @Override
    public int getProgress_Total() {
        return this.finalProgress;
    }

    public void stopScan() {
        this.isScanning = false;
    }

    protected void scanDoneEvent() {
        if (!this.isScanning) {
            return;
        }
        this.pipeline.finish();
        this.stopScan();
    }
}

