/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.dealias;

import eu.ha3.matmos.Matmos;
import java.util.Map;

public class AliasEntry
implements Map.Entry<String, String> {
    private String key;
    private String value;
    private String path;
    private boolean showWarnings;
    private int lineno;

    public AliasEntry(String key, String value, String path, int lineno, boolean showWarnings) {
        this.key = key;
        this.value = value;
        this.path = path;
        this.lineno = lineno;
        this.showWarnings = showWarnings;
    }

    public AliasEntry(String key, String path, int lineno, String value) {
        this(key, value, path, lineno, true);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    public boolean doesShowWarnings() {
        return this.showWarnings;
    }

    public void warn(String msg) {
        if (this.showWarnings || Matmos.VERBOSE_ENGINE_LOGGING) {
            Matmos.ALIASLOGGER.warn(this.path + ":" + this.lineno + ": " + msg);
        }
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineno;
    }
}

