/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class SoundsJsonGenerator
implements Runnable {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private List<String> filenames = new ArrayList<String>();
    private boolean OVERWRITE_FILE = true;
    private final File soundsFolder;
    private final File jsonFile;

    public SoundsJsonGenerator(File soundsFolder, File jsonFile) {
        this.soundsFolder = soundsFolder;
        this.jsonFile = jsonFile;
    }

    @Override
    public void run() {
        this.listAllFiles();
        ArrayList<String> workingNames = new ArrayList<String>();
        for (String string : this.filenames) {
            if (!string.endsWith(".ogg")) continue;
            workingNames.add(string.substring(0, string.indexOf(".")));
        }
        LinkedHashMap catNames = new LinkedHashMap();
        for (String string : workingNames) {
            String newName = string.replace('/', '.').replaceAll("[0-9]", "");
            if (!catNames.containsKey(newName)) {
                catNames.put(newName, new ArrayList());
            }
            if (!string.contains("stream")) {
                ((List)catNames.get(newName)).add(string);
                continue;
            }
            LinkedHashMap<String, Object> streaming = new LinkedHashMap<String, Object>();
            streaming.put("name", string);
            streaming.put("stream", true);
            ((List)catNames.get(newName)).add(streaming);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String catName : catNames.keySet()) {
            LinkedHashMap<String, String> blob = new LinkedHashMap<String, String>();
            blob.put("category", catName.contains("underwater") ? "weather" : "ambient");
            blob.put("sounds", (String)catNames.get(catName));
            linkedHashMap.put(catName, blob);
        }
        String string = gson.toJson(linkedHashMap);
        if (!this.OVERWRITE_FILE) {
            System.out.println(string);
            return;
        }
        try (FileWriter writer = new FileWriter(this.jsonFile);){
            writer.append(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void listAllFiles() {
        this.listFiles(this.soundsFolder, this.soundsFolder);
    }

    private void listFiles(File root, File subdir) {
        for (File file : subdir.listFiles()) {
            if (file.isDirectory()) {
                this.listFiles(root, file);
                continue;
            }
            this.filenames.add(root.toURI().relativize(file.toURI()).getPath().toLowerCase().toString());
        }
    }
}

