/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.game.user;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.game.user.VolumeScroller;
import eu.ha3.matmos.gui.GuiMatMenu;
import eu.ha3.matmos.lib.eu.ha3.easy.TimeStatistic;
import eu.ha3.matmos.lib.eu.ha3.mc.abstraction.util.ATextFormatting;
import eu.ha3.matmos.lib.eu.ha3.mc.convenience.Ha3HoldActions;
import eu.ha3.matmos.lib.eu.ha3.mc.convenience.Ha3KeyHolding;
import eu.ha3.matmos.lib.eu.ha3.mc.convenience.Ha3KeyManager_2;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsFrameEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsTickEvents;
import eu.ha3.matmos.util.MAtUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class UserControl
implements Ha3HoldActions,
SupportsTickEvents,
SupportsFrameEvents {
    private final Matmos mod;
    private final Ha3KeyManager_2 keyManager = new Ha3KeyManager_2();
    private KeyBinding keyBindingMain;
    private VolumeScroller scroller;
    private int tickRound;
    private int loadingCount;

    public UserControl(Matmos mod) {
        this.mod = mod;
    }

    public void load() {
        this.keyBindingMain = new KeyBinding("MAtmos", 62, "key.categories.misc");
        Minecraft.func_71410_x().field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])Minecraft.func_71410_x().field_71474_y.field_74324_K, (Object[])new KeyBinding[]{this.keyBindingMain});
        this.keyBindingMain.func_151462_b(this.mod.getConfig().getInteger("key.code"));
        KeyBinding.func_74508_b();
        this.keyManager.addKeyBinding(this.keyBindingMain, new Ha3KeyHolding(this, 7));
        this.scroller = new VolumeScroller(this.mod);
    }

    private String getKeyBindingMainFriendlyName() {
        if (this.keyBindingMain == null) {
            return "undefined";
        }
        return Keyboard.getKeyName((int)this.keyBindingMain.func_151463_i());
    }

    @Override
    public void onTick() {
        int keyCode;
        this.keyManager.onTick();
        if (this.tickRound == 0 && (keyCode = this.keyBindingMain.func_151463_i()) != this.mod.getConfig().getInteger("key.code")) {
            this.mod.getConfig().setProperty("key.code", (Object)keyCode);
            this.mod.saveConfig();
        }
        this.tickRound = (this.tickRound + 1) % 100;
        this.scroller.routine();
        if (this.scroller.isRunning()) {
            this.mod.getGlobalVolumeControl().setVolumeAndUpdate(this.scroller.getValue());
        }
    }

    @Override
    public void onFrame(float fspan) {
        this.scroller.draw(fspan);
    }

    private void printUnusualMessages() {
        if (!this.mod.isInitialized()) {
            this.mod.getChatter().printChat(ATextFormatting.RED, "Unknown error: MAtmos isn't initialized");
        } else {
            if (!MAtUtil.isSoundMasterEnabled()) {
                this.mod.getChatter().printChat(ATextFormatting.RED, "Warning: ", ATextFormatting.WHITE, "Sounds are turned off in your game settings!");
            }
            if (!MAtUtil.isSoundAmbientEnabled()) {
                this.mod.getChatter().printChat(ATextFormatting.RED, "Warning: ", ATextFormatting.WHITE, "Ambient sounds are at 0%% volume in the Minecraft options menu!");
            }
        }
    }

    @Override
    public void beginHold() {
        if (this.mod.isActivated()) {
            this.scroller.start();
        }
    }

    @Override
    public void shortPress() {
        if (!this.mod.isActivated()) {
            this.whenWantsToggle();
        } else {
            this.displayMenu();
        }
        this.printUnusualMessages();
    }

    @Override
    public void endHold() {
        if (this.scroller.isRunning()) {
            this.scroller.stop();
            this.mod.getConfig().setProperty("globalvolume.scale", Float.valueOf(this.mod.getGlobalVolumeControl().getVolume()));
            this.mod.saveConfig();
        }
        this.whenWantsForcing();
        this.printUnusualMessages();
    }

    private void whenWantsToggle() {
        if (this.mod.isActivated()) {
            this.mod.deactivate();
            this.mod.getChatter().printChat(ATextFormatting.YELLOW, "Stopped. Press ", ATextFormatting.WHITE, this.getKeyBindingMainFriendlyName(), ATextFormatting.YELLOW, " to re-enable.");
        } else if (this.mod.isInitialized()) {
            if (this.loadingCount != 0) {
                this.mod.getChatter().printChat(ATextFormatting.GREEN, "Loading...");
            } else {
                this.mod.getChatter().printChat(ATextFormatting.GREEN, "Loading...", ATextFormatting.YELLOW, " (Hold ", ATextFormatting.WHITE, this.getKeyBindingMainFriendlyName() + " down", ATextFormatting.YELLOW, " to tweak the volume)");
            }
            ++this.loadingCount;
            this.mod.activate();
        } else if (!this.mod.isInitialized()) {
            this.whenUninitializedAction();
        }
    }

    private void whenUninitializedAction() {
        if (this.mod.isInitialized()) {
            return;
        }
        TimeStatistic stat = new TimeStatistic();
        this.mod.start();
        this.mod.getChatter().printChat(ATextFormatting.GREEN, "Loading for the first time (" + stat.getSecondsAsString(2) + "s)");
    }

    private void whenWantsForcing() {
        if (!this.mod.isActivated() && this.mod.isInitialized()) {
            TimeStatistic stat = new TimeStatistic();
            this.mod.refresh();
            this.mod.activate();
            this.mod.getChatter().printChat(ATextFormatting.GREEN, "Reloading expansions (" + stat.getSecondsAsString(2) + "s)");
        } else if (!this.mod.isInitialized()) {
            this.whenUninitializedAction();
        }
    }

    private void displayMenu() {
        if (this.mod.isActivated() && this.mod.util().isCurrentScreen(null)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMatMenu((GuiScreen)this.mod.util().getCurrentScreen(), this.mod));
        }
    }

    @Override
    public void beginPress() {
    }

    @Override
    public void endPress() {
    }
}

