/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.game.user;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.sheet.Sheet;
import eu.ha3.matmos.data.modules.ModuleRegistry;
import eu.ha3.matmos.data.scanners.Progress;
import eu.ha3.matmos.game.user.VisualExpansionDebugging;
import eu.ha3.matmos.lib.eu.ha3.mc.abstraction.util.ATextFormatting;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsFrameEvents;
import eu.ha3.matmos.util.math.Numbers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class VisualDebugger
implements SupportsFrameEvents {
    private final Matmos mod;
    private final ModuleRegistry dataGatherer;
    private DebugMode mode = DebugMode.NONE;
    private VisualExpansionDebugging ed;
    private String scanDebug;
    private boolean deltas = false;

    public VisualDebugger(Matmos mod, ModuleRegistry dataGatherer) {
        this.mod = mod;
        this.dataGatherer = dataGatherer;
    }

    public List<String> obtainSheetNamesCopy() {
        ArrayList<String> sheetNames = new ArrayList<String>(this.dataGatherer.getData().getSheetNames());
        Collections.sort(sheetNames);
        return sheetNames;
    }

    public void debugModeExpansion(VisualExpansionDebugging ed) {
        this.ed = ed;
        this.mode = DebugMode.EXPANSION;
    }

    public void debugModeScan(String name) {
        this.scanDebug = name;
        this.mode = DebugMode.SCAN;
    }

    public void noDebug() {
        this.mode = DebugMode.NONE;
    }

    @Override
    public void onFrame(float semi) {
        if (this.mod.isDebugMode()) {
            this.mod.util().prepareDrawString();
            this.mod.util().drawString(ATextFormatting.GRAY.toString() + this.mod.getLag().getMilliseconds() + "ms", 1.0f, 1.0f, 0, 0, '3', 0, 0, 0, 0, true);
        }
        if (this.mode == DebugMode.NONE) {
            return;
        }
        if (this.mode == DebugMode.EXPANSION && semi >= 0.0f && this.mod.util().getCurrentScreen() != null && !(this.mod.util().getCurrentScreen() instanceof GuiChat)) {
            return;
        }
        switch (this.mode) {
            case SCAN: {
                this.debugScan();
                break;
            }
            case EXPANSION: {
                this.ed.onFrame(semi);
                break;
            }
        }
    }

    private void debugScan() {
        this.debugScanWithSheet(this.dataGatherer.getData().getSheet(this.scanDebug), false);
        if (this.deltas && this.dataGatherer.getData().getSheetNames().contains(this.scanDebug + "_delta")) {
            this.debugScanWithSheet(this.dataGatherer.getData().getSheet(this.scanDebug + "_delta"), true);
        }
    }

    private void debugScanWithSheet(Sheet sheet, boolean isDeltaPass) {
        Minecraft mc = Minecraft.func_71410_x();
        int fac = new ScaledResolution(mc).func_78325_e();
        float scale = 2.0f / (float)fac;
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        int ALL = 50;
        ArrayList<String> sort = new ArrayList<String>(sheet.keySet());
        if (this.scanDebug.startsWith("scan_")) {
            try {
                Collections.sort(sort, (o1, o2) -> {
                    boolean o1IsVar = o1.startsWith(".");
                    boolean o2IsVar = o2.startsWith(".");
                    if (o1IsVar && o2IsVar) {
                        return o1.compareTo((String)o2);
                    }
                    if (o1IsVar) {
                        return 1;
                    }
                    if (o2IsVar) {
                        return -1;
                    }
                    Long l1 = Numbers.toLong(sheet.get((String)o1));
                    Long l2 = Numbers.toLong(sheet.get((String)o2));
                    if (l1 == null && l2 == null) {
                        return o1.compareTo((String)o2);
                    }
                    if (l1 == null) {
                        return -1;
                    }
                    if (l2 == null) {
                        return 1;
                    }
                    if (l1 > l2) {
                        return 1;
                    }
                    if (l1 < l2) {
                        return -1;
                    }
                    return o1.compareTo((String)o2);
                });
                Collections.reverse(sort);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        int total = 0;
        for (String index : sort) {
            Long l;
            if (index.contains("^") || (l = Numbers.toLong(sheet.get(index))) == null) continue;
            total += (int)l.longValue();
        }
        FontRenderer fontRenderer = mc.field_71466_p;
        int lineNumber = 0;
        if (this.scanDebug.startsWith("scan_large")) {
            Progress progressObject = this.dataGatherer.getLargeScanProgress();
            float progress = (float)progressObject.getProgress_Current() / (float)progressObject.getProgress_Total();
            fontRenderer.func_175063_a("Scan [" + mc.field_71441_e.func_72800_K() + "]: " + StringUtils.repeat((String)"|", (int)((int)(100.0f * progress))) + " (" + (int)(progress * 100.0f) + "%)", 20.0f, (float)(2 + 9 * lineNumber), 0xFFFFCC);
        }
        ++lineNumber;
        int leftAlign = 2 + (isDeltaPass ? 300 : 0);
        for (String index : sort) {
            String val;
            if (lineNumber > 100 || index.contains("^")) continue;
            if (this.scanDebug.startsWith("scan_") || this.scanDebug.equals("block_contact")) {
                String percentage;
                if (index.startsWith(".")) {
                    fontRenderer.func_175063_a(ATextFormatting.AQUA + index + ": " + ATextFormatting.YELLOW + sheet.get(index) + ATextFormatting.RESET, (float)leftAlign, (float)(2 + 9 * lineNumber), 0xFFFFFF);
                    ++lineNumber;
                    continue;
                }
                Long count = Numbers.toLong(sheet.get(index));
                if (count == null || count <= 0L) continue;
                float scalar = (float)count.longValue() / (float)total;
                String string = percentage = !this.scanDebug.endsWith("_p1k") ? Float.toString((float)Math.round(scalar * 1000.0f) / 10.0f) : Integer.toString(Math.round(scalar * 100.0f));
                if (percentage.equals("0.0")) {
                    percentage = "0";
                }
                int fill = Math.round(scalar * 50.0f * 2.0f);
                int superFill = 0;
                if (fill > 100) {
                    fill = 100;
                }
                if (fill > 50) {
                    superFill = fill - 50;
                }
                String bars = "";
                if (superFill > 0) {
                    bars = bars + ATextFormatting.YELLOW + StringUtils.repeat((String)"|", (int)superFill);
                }
                bars = bars + ATextFormatting.RESET + StringUtils.repeat((String)"|", (int)(fill - superFill * 2));
                if (index.startsWith("minecraft:")) {
                    index = index.substring(10);
                }
                fontRenderer.func_175063_a(bars + (fill == 100 ? ATextFormatting.YELLOW + "++" + ATextFormatting.RESET : "") + " (" + count + ", " + percentage + "%) " + index, (float)leftAlign, (float)(2 + 9 * lineNumber), 0xFFFFFF);
                ++lineNumber;
                continue;
            }
            if (this.scanDebug.startsWith("detect_")) {
                val = sheet.get(index);
                if (val.equals("0") || val.equals(Integer.toString(Integer.MAX_VALUE))) continue;
                fontRenderer.func_175063_a(String.format("%s (%s): %s", index, index, val), (float)leftAlign, (float)(2 + 9 * lineNumber), 0xFFFFFF);
                ++lineNumber;
                continue;
            }
            val = sheet.get(index);
            int color = 0xFFFFFF;
            if (val.equals("0")) {
                color = 0xFF0000;
            } else if (val.equals("1")) {
                color = 39423;
            }
            fontRenderer.func_175063_a(index + ": " + val, (float)leftAlign, (float)(2 + 9 * lineNumber), color);
            ++lineNumber;
        }
        GL11.glPopMatrix();
    }

    public void toggleDeltas() {
        this.deltas = !this.deltas;
    }

    private static enum DebugMode {
        NONE,
        SCAN,
        EXPANSION;

    }
}

