/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.game.user;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Provider;
import eu.ha3.matmos.core.ProviderCollection;
import eu.ha3.matmos.core.logic.Visualized;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsFrameEvents;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class VisualExpansionDebugging
implements SupportsFrameEvents {
    private final Matmos mod;
    private final String ex;
    private int GAP = 10;

    public VisualExpansionDebugging(Matmos mod, String ex) {
        this.mod = mod;
        this.ex = ex;
    }

    @Override
    public void onFrame(float semi) {
        Minecraft mc = Minecraft.func_71410_x();
        int fac = new ScaledResolution(mc).func_78325_e();
        float scale = 1.0f / (float)fac;
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        if (!this.mod.getExpansionList().containsKey(this.ex)) {
            IDontKnowHowToCode.warnOnce("Problem getting expansion " + this.ex + " to debug");
            return;
        }
        try {
            Exception loadException = this.mod.getExpansionList().get(this.ex).getLoadException();
            if (loadException == null) {
                ProviderCollection providers = this.mod.getExpansionList().get(this.ex).obtainProvidersForDebugging();
                Distances condition = this.distances(providers.getCondition());
                Distances junction = this.distances(providers.getJunction());
                Distances machine = this.distances(providers.getMachine());
                int yyBase = 30;
                this.scrub(condition, 20, yyBase);
                this.scrub(junction, 400, yyBase);
                this.scrub(machine, 600, yyBase);
            } else {
                mc.field_71466_p.func_175063_a("There was an error loading the file:", 10.0f, 30.0f, 0xFFFF00);
                mc.field_71466_p.func_175063_a(loadException.getMessage(), 10.0f, 40.0f, 0xFFFF00);
            }
        }
        catch (Exception e) {
            IDontKnowHowToCode.whoops__printExceptionToChat(this.mod.getChatter(), e, this);
        }
        GL11.glPopMatrix();
    }

    private void link(Distances reliables, int xR, int yR, Collection<String> dependencies, int xD, int yDapplied, boolean right) {
        for (String dependency : dependencies) {
            reliables.get(dependency);
            reliables.visualize(dependency).isActive();
        }
    }

    private void scrub(Distances subject, int x, int y) {
        for (String name : subject.keySet()) {
            Visualized vis = subject.visualize(name);
            this.paint(x, y + (Integer)subject.get(name) * this.GAP, vis);
        }
    }

    private void paint(int x, int y, Visualized vis) {
        String name = vis.getName();
        String feed = vis.getFeed();
        boolean isActive = vis.isActive();
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_175063_a(name + "(" + feed + ")", (float)x, (float)y, isActive ? 39423 : 0xFF0000);
    }

    public Distances distances(Provider<? extends Visualized> provider) {
        Distances map = new Distances(provider);
        ArrayList<String> list = new ArrayList<String>(provider.keySet());
        Collections.sort(list);
        int i = 0;
        for (String name : list) {
            map.put(name, i);
            ++i;
        }
        return map;
    }

    private class Distances
    extends TreeMap<String, Integer> {
        private Provider<? extends Visualized> provider;

        public Distances(Provider<? extends Visualized> provider) {
            this.provider = provider;
        }

        public Visualized visualize(String name) {
            return this.provider.get(name);
        }
    }
}

