/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.gui;

import com.google.common.collect.Sets;
import eu.ha3.matmos.core.Provider;
import eu.ha3.matmos.core.expansion.Expansion;
import eu.ha3.matmos.core.logic.Condition;
import eu.ha3.matmos.gui.GuiExpansionOverrides;
import eu.ha3.matmos.lib.eu.ha3.mc.abstraction.util.ATextFormatting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiExpansionOverrideList
extends GuiListExtended {
    private final Expansion expansion;
    private final List<OverrideEntry> listEntries = new ArrayList<OverrideEntry>();
    private final Map<String, String> overrides;
    private final Provider<Condition> conditionProvider;
    private final Minecraft mc;
    private int padding = 16;

    public GuiExpansionOverrideList(Minecraft mc, GuiExpansionOverrides eo, Expansion expansion) {
        super(mc, eo.field_146294_l, eo.field_146295_m, 0, eo.field_146295_m - 20, 8);
        this.expansion = expansion;
        this.overrides = expansion.getConditionValueOverrides();
        this.mc = mc;
        this.conditionProvider = expansion.obtainProvidersForDebugging().getCondition();
        Set conditions = this.conditionProvider.keySet().stream().filter(s -> !s.startsWith("_")).collect(Collectors.toSet());
        if (!conditions.isEmpty()) {
            Collection posConditions = conditions.stream().filter(c -> this.conditionProvider.get((String)c).getIndex().getSheet().equals("cb_pos")).collect(Collectors.toList());
            Collection otherConditions = Sets.difference(conditions, new HashSet(posConditions)).stream().collect(Collectors.toList());
            this.listEntries.add(new OverrideEntry(ATextFormatting.BOLD + I18n.func_135052_a((String)"mat.title.conditionoverrides", (Object[])new Object[0]) + ATextFormatting.RESET + ATextFormatting.GRAY + " (" + expansion.getName() + ".cfg)", true));
            if (!posConditions.isEmpty()) {
                this.listEntries.add(new OverrideEntry(I18n.func_135052_a((String)"mat.options.overridesection.pos", (Object[])new Object[0]), true));
                posConditions.forEach(k -> this.listEntries.add(new OverrideEntry((String)k, this.listEntries.size())));
                this.listEntries.add(new OverrideEntry("", true));
            }
            if (!otherConditions.isEmpty()) {
                this.listEntries.add(new OverrideEntry(I18n.func_135052_a((String)"mat.options.overridesection.other", (Object[])new Object[0]), true));
                otherConditions.forEach(k -> this.listEntries.add(new OverrideEntry((String)k, this.listEntries.size())));
            }
        } else {
            this.listEntries.add(new OverrideEntry(I18n.func_135052_a((String)"mat.options.overridesection.nothing", (Object[])new Object[0]), true));
        }
    }

    public void onGuiClosed() {
        for (OverrideEntry oe : this.listEntries) {
            if (oe.tf == null) continue;
            String text = oe.getText();
            if (!text.equals("")) {
                this.overrides.put(oe.s, text);
                continue;
            }
            this.overrides.remove(oe.s);
        }
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.listEntries.get(index);
    }

    protected int func_148127_b() {
        return this.listEntries.size();
    }

    public boolean func_148179_a(int x, int y, int buttonClicked) {
        this.listEntries.forEach(l -> l.mouseClicked(x, y, buttonClicked));
        return true;
    }

    public void keyTyped(char ch, int i) {
        this.listEntries.forEach(l -> l.keyTyped(ch, i));
    }

    void updateScreen() {
        this.listEntries.forEach(l -> l.updateScreen());
    }

    public int func_148139_c() {
        return this.field_148155_a;
    }

    protected int func_148137_d() {
        return this.field_148155_a - this.padding;
    }

    public class OverrideEntry
    implements GuiListExtended.IGuiListEntry {
        private String s;
        private GuiTextField tf;

        public OverrideEntry(String s, boolean sectionHeader, int index) {
            this.s = s;
            if (!sectionHeader) {
                this.tf = new GuiTextField(index, ((GuiExpansionOverrideList)GuiExpansionOverrideList.this).mc.field_71466_p, 100, 0, 100, 10);
                this.tf.func_146180_a(GuiExpansionOverrideList.this.expansion.getConditionValueOverrides().getOrDefault(s, ""));
            }
        }

        public OverrideEntry(String s, boolean sectionHeader) {
            this(s, sectionHeader, -1);
        }

        public OverrideEntry(String s, int index) {
            this(s, false, index);
        }

        public void func_192634_a(int index, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            GL11.glPushMatrix();
            int fac = 2;
            float scale = 1.0f / (float)fac;
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            Minecraft mc = Minecraft.func_71410_x();
            if (this.tf != null) {
                if (index % 2 == 0) {
                    Gui.func_73734_a((int)((x + GuiExpansionOverrideList.this.padding) * fac), (int)((y - 1) * fac), (int)((GuiExpansionOverrideList.this.field_148155_a - GuiExpansionOverrideList.this.padding) * fac), (int)((y + 4 + 2) * fac), (int)0x20FFFFFF);
                }
                Condition cond = (Condition)GuiExpansionOverrideList.this.conditionProvider.get(this.s);
                boolean overridden = !this.tf.func_146179_b().isEmpty();
                mc.field_71466_p.func_78276_b((overridden ? ATextFormatting.GOLD + "" + ATextFormatting.BOLD : ATextFormatting.WHITE) + cond.getName() + "  " + ATextFormatting.GRAY + cond.getFeed(), (x + GuiExpansionOverrideList.this.padding) * fac, y * fac, 0xFFFFFF);
                this.tf.field_146209_f = (GuiExpansionOverrideList.this.field_148155_a - GuiExpansionOverrideList.this.padding - 4 - GuiExpansionOverrideList.this.padding - 50) * fac;
                this.tf.field_146210_g = y * fac;
                this.tf.func_146194_f();
            } else {
                mc.field_71466_p.func_78276_b(this.s, (GuiExpansionOverrideList.this.field_148155_a / 2 - mc.field_71466_p.func_78256_a(this.s) / 4) * fac, y * fac, 0xFFFFFF);
            }
            GL11.glPopMatrix();
        }

        public String getText() {
            return this.tf == null ? "" : this.tf.func_146179_b();
        }

        public void mouseClicked(int x, int y, int buttonClicked) {
            if (this.tf != null) {
                this.tf.func_146192_a(x * 2, y * 2, buttonClicked);
            }
        }

        public void keyTyped(char ch, int i) {
            if (this.tf != null) {
                this.tf.func_146201_a(ch, i);
            }
        }

        public void updateScreen() {
            if (this.tf != null) {
                this.tf.func_146178_a();
            }
        }

        public boolean func_148278_a(int p_148278_1_, int p_148278_2_, int p_148278_3_, int p_148278_4_, int p_148278_5_, int p_148278_6_) {
            return false;
        }

        public void func_148277_b(int p_148277_1_, int p_148277_2_, int p_148277_3_, int p_148277_4_, int p_148277_5_, int p_148277_6_) {
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }
    }
}

