/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;

public class HaddonVersion
implements Comparable<HaddonVersion> {
    public static final HaddonVersion NO_VERSION = new HaddonVersion(-1);
    Optional<String> stringRepresentation;
    private final int[] components;

    public HaddonVersion(String versionString) {
        this(Optional.of(versionString), new int[0]);
    }

    public HaddonVersion(int ... components) {
        this(Optional.empty(), components);
    }

    public HaddonVersion(Optional<String> stringRepresentation, int ... components) {
        this.stringRepresentation = stringRepresentation;
        if (stringRepresentation.isPresent() && components.length == 0) {
            try {
                components = Arrays.stream(stringRepresentation.get().split("\\.|-")).mapToInt(x -> Integer.parseInt(x)).toArray();
            }
            catch (Exception e) {
                LogManager.getLogger((String)"haddon").warn("Invalid version " + stringRepresentation.get());
            }
        }
        this.components = components.length == 0 ? new int[]{-1} : components;
    }

    @Override
    public int compareTo(HaddonVersion o) {
        int minLength = Math.min(this.components.length, o.components.length);
        for (int i = 0; i < minLength; ++i) {
            if (this.components[i] < o.components[i]) {
                return -1;
            }
            if (this.components[i] <= o.components[i]) continue;
            return 1;
        }
        return this.components.length > o.components.length ? 1 : -1;
    }

    public int getComponent(int index) {
        return this.components[index];
    }

    public int getMajorVersion() {
        return this.getComponent(0);
    }

    public String toString() {
        return this.stringRepresentation.orElse(String.join((CharSequence)".", Arrays.stream(this.components).boxed().map(x -> String.valueOf(x)).collect(Collectors.toList())));
    }

    public boolean equals(Object obj) {
        if (obj instanceof HaddonVersion) {
            HaddonVersion o = (HaddonVersion)obj;
            return Arrays.equals(this.components, o.components);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Arrays.hashCode(this.components);
    }
}

