/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.eu.ha3.util.property.simple;

import eu.ha3.matmos.lib.eu.ha3.util.property.contract.PropertyHolder;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.PropertyMissingException;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.PropertyTypeException;
import java.util.HashMap;
import java.util.Map;

public class PropertyCell
implements PropertyHolder {
    private Map<String, String> properties = new HashMap<String, String>();

    @Override
    public String getString(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        throw new PropertyMissingException(name);
    }

    @Override
    public boolean getBoolean(String name) {
        try {
            return Boolean.parseBoolean(this.getString(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException(e);
        }
    }

    @Override
    public int getInteger(String name) {
        try {
            return Integer.parseInt(this.getString(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException(e);
        }
    }

    @Override
    public float getFloat(String name) {
        try {
            return Float.parseFloat(this.getString(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException(e);
        }
    }

    @Override
    public long getLong(String name) {
        try {
            return Long.parseLong(this.getString(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException(e);
        }
    }

    @Override
    public double getDouble(String name) {
        try {
            return Double.parseDouble(this.getString(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException(e);
        }
    }

    public void setProperty(String name, Object o) {
        this.properties.put(name, o.toString());
    }

    @Override
    public Map<String, String> getAllProperties() {
        return this.properties;
    }
}

