/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.lang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTable<T> {
    private volatile ConcurrentHashMap<Class<?>, T> _map = new ConcurrentHashMap();

    public int size() {
        return this._map.size();
    }

    public void put(Class<?> klass, T object) {
        this._map.put(klass, object);
    }

    public T get(Class<?> klass) {
        T result = this._map.get(klass);
        if (result != null) {
            return result;
        }
        Class<?> superclass = klass.getSuperclass();
        if (superclass == null) {
            return null;
        }
        result = this.get(superclass);
        if (result != null) {
            this._map.put(klass, result);
        }
        return result;
    }

    public T getByObject(Object obj) {
        return this.get(obj.getClass());
    }

    public void replace(Class<?> klass, T value) {
        ConcurrentHashMap newMap = new ConcurrentHashMap();
        for (Map.Entry<Class<?>, T> entry : this._map.entrySet()) {
            if (klass.isAssignableFrom(entry.getKey())) {
                newMap.put(entry.getKey(), value);
                continue;
            }
            newMap.put(entry.getKey(), entry.getValue());
        }
        this._map = newMap;
    }
}

