/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.lang;

import eu.ha3.matmos.lib.net.sf.kdgcommons.collections.HashMultimap;
import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    private static Map<Class<?>, Class<?>> primitiveLookup = new HashMap();
    private static Map<Class<?>, Integer> integralDistance;
    private static Map<Class<?>, Integer> floatDistance;

    public static String internalNameToExternal(String name) {
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case 'V': {
                    return "void";
                }
                case 'Z': {
                    return "boolean";
                }
                case 'C': {
                    return "char";
                }
                case 'B': {
                    return "byte";
                }
                case 'S': {
                    return "short";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'F': {
                    return "float";
                }
                case 'D': {
                    return "double";
                }
            }
            throw new IllegalArgumentException("invalid type name: " + name);
        }
        int arrayCount = name.lastIndexOf("[") + 1;
        String arraySuffix = "";
        for (int ii = 0; ii < arrayCount; ++ii) {
            arraySuffix = arraySuffix + "[]";
        }
        if (arrayCount > 0) {
            name = name.substring(arrayCount);
        }
        if (name.startsWith("L")) {
            name = name.substring(1, name.length() - 1);
            name = name.replace('/', '.');
        } else {
            name = ClassUtil.internalNameToExternal(name);
        }
        return name + arraySuffix;
    }

    public static Class<?> getPrimitiveType(Object val) {
        if (val == null) {
            return null;
        }
        return primitiveLookup.get(val.getClass());
    }

    @Deprecated
    public static Method[] getAllMethods(Class<?> klass) {
        if (klass == null) {
            return new Method[0];
        }
        Method[] myMethods = klass.getDeclaredMethods();
        Method[] parentMethods = ClassUtil.getAllMethods(klass.getSuperclass());
        ArrayList<Method> combined = new ArrayList<Method>(myMethods.length + parentMethods.length);
        combined.addAll(Arrays.asList(myMethods));
        for (Method method : parentMethods) {
            if (ClassUtil.isOverridden(method, myMethods)) continue;
            combined.add(method);
        }
        return combined.toArray(new Method[combined.size()]);
    }

    public static Method[] getDeclaredMethodsByAccess(Class<?> klass, boolean isPublic, boolean isProtected, boolean isPrivate, boolean isDefault) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : klass.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (isPublic && Modifier.isPublic(modifiers)) {
                result.add(method);
                continue;
            }
            if (isPrivate && Modifier.isPrivate(modifiers)) {
                result.add(method);
                continue;
            }
            if (isProtected && Modifier.isProtected(modifiers)) {
                result.add(method);
                continue;
            }
            if (!isDefault || Modifier.isPublic(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers)) continue;
            result.add(method);
        }
        return result.toArray(new Method[result.size()]);
    }

    public static Method[] getVisibleMethods(Class<?> klass) {
        HashMultimap<String, Method> methodMap = ClassUtil.getVisibleMethodMap(klass);
        Method[] result = new Method[methodMap.size()];
        int ii = 0;
        for (Map.Entry<String, Method> entry : methodMap.entries()) {
            result[ii++] = entry.getValue();
        }
        return result;
    }

    public static HashMultimap<String, Method> getVisibleMethodMap(Class<?> klass) {
        HashMultimap<String, Method> methodMap = new HashMultimap<String, Method>();
        boolean includePrivates = true;
        while (klass != null) {
            for (Method method : ClassUtil.getDeclaredMethodsByAccess(klass, true, true, includePrivates, true)) {
                ClassUtil.addIfNotPresent(method, methodMap);
            }
            includePrivates = false;
            klass = klass.getSuperclass();
        }
        return methodMap;
    }

    public static Method[] getAnnotatedMethods(Class<?> klass, Class<? extends Annotation> annotationKlass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : ClassUtil.getVisibleMethods(klass)) {
            if (method.getAnnotation(annotationKlass) == null) continue;
            result.add(method);
        }
        return result.toArray(new Method[result.size()]);
    }

    public static Method getBestMethod(Class<?> klass, String methodName, Object ... args) {
        Method bestMethod = null;
        int bestDistance = Integer.MAX_VALUE;
        boolean multipleBest = true;
        HashMultimap<String, Method> methodMap = ClassUtil.getVisibleMethodMap(klass);
        for (Method method : methodMap.getAll(methodName)) {
            int distance = ClassUtil.matchParameters(method.getParameterTypes(), args);
            if (distance < 0) continue;
            if (distance == bestDistance) {
                multipleBest = true;
            }
            if (distance >= bestDistance) continue;
            multipleBest = false;
            bestDistance = distance;
            bestMethod = method;
        }
        return multipleBest ? null : bestMethod;
    }

    public static boolean isOverridden(Method method, Method[] methods) {
        for (Method override : methods) {
            if (!override.getName().equals(method.getName()) || !Arrays.equals(override.getParameterTypes(), method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    private static void addIfNotPresent(Method method, HashMultimap<String, Method> methodMap) {
        String methodName = method.getName();
        if (!methodMap.containsKey(methodName)) {
            methodMap.put(methodName, method);
            return;
        }
        Class<?>[] params = method.getParameterTypes();
        for (Method mappedMethod : methodMap.getAll(methodName)) {
            if (!ObjectUtil.equals(mappedMethod.getParameterTypes(), params)) continue;
            return;
        }
        methodMap.put(methodName, method);
    }

    private static int matchParameters(Class<?>[] params, Object[] args) {
        int distance = 0;
        if (params.length != args.length) {
            return -1;
        }
        for (int ii = 0; ii < params.length; ++ii) {
            if (args[ii] == null) continue;
            if (params[ii].isPrimitive()) {
                distance = ClassUtil.matchPrimitive(params[ii], args[ii]);
                continue;
            }
            Class<?> argType = args[ii].getClass();
            if (!params[ii].isAssignableFrom(argType)) {
                return -1;
            }
            while (argType != params[ii]) {
                argType = argType.getSuperclass();
                ++distance;
            }
        }
        return distance;
    }

    private static int matchPrimitive(Class<?> paramType, Object arg) {
        Class<?> argType = ClassUtil.getPrimitiveType(arg);
        if (argType == null) {
            return -1;
        }
        if (paramType == argType) {
            return 1;
        }
        if (integralDistance.containsKey(argType) && integralDistance.containsKey(paramType)) {
            int paramDepth;
            int argDepth = integralDistance.get(argType);
            if (argDepth < (paramDepth = integralDistance.get(paramType).intValue())) {
                return 1 + (paramDepth - argDepth);
            }
        } else if (floatDistance.containsKey(argType) && floatDistance.containsKey(paramType)) {
            int paramDepth;
            int argDepth = floatDistance.get(argType);
            if (argDepth < (paramDepth = floatDistance.get(paramType).intValue())) {
                return 1 + (paramDepth - argDepth);
            }
        } else if (integralDistance.containsKey(argType) && paramType == Double.TYPE) {
            return 5;
        }
        return -1;
    }

    static {
        primitiveLookup.put(Boolean.class, Boolean.TYPE);
        primitiveLookup.put(Byte.class, Byte.TYPE);
        primitiveLookup.put(Short.class, Short.TYPE);
        primitiveLookup.put(Integer.class, Integer.TYPE);
        primitiveLookup.put(Long.class, Long.TYPE);
        primitiveLookup.put(Float.class, Float.TYPE);
        primitiveLookup.put(Double.class, Double.TYPE);
        integralDistance = new HashMap();
        integralDistance.put(Byte.TYPE, 1);
        integralDistance.put(Short.TYPE, 2);
        integralDistance.put(Integer.TYPE, 3);
        integralDistance.put(Long.TYPE, 4);
        floatDistance = new HashMap();
        floatDistance.put(Float.TYPE, 1);
        floatDistance.put(Double.TYPE, 2);
    }
}

