/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.util;

import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCLIParser {
    private List<OptionDefinition> optionDefs;
    private Map<Object, OptionDefinition> defsByKey = new HashMap<Object, OptionDefinition>();
    private Map<String, OptionDefinition> defsByStr = new HashMap<String, OptionDefinition>();
    private Map<Object, Option> options = new LinkedHashMap<Object, Option>();
    private List<String> nonOptions = new ArrayList<String>();
    private Iterator<String> shiftArgs;

    public SimpleCLIParser(String[] argv, OptionDefinition ... optionDefs) {
        this.optionDefs = Arrays.asList(optionDefs);
        this.buildOptionLookups();
        this.processArgs(argv);
        this.shiftArgs = this.nonOptions.iterator();
    }

    private void buildOptionLookups() {
        for (OptionDefinition option : this.optionDefs) {
            this.defsByKey.put(option.key, option);
            this.defsByStr.put(option.enableVal, option);
            this.defsByStr.put(option.disableVal, option);
        }
    }

    private void processArgs(String[] argv) {
        Iterator<String> itx = Arrays.asList(argv).iterator();
        while (itx.hasNext()) {
            String arg = itx.next();
            if (this.tryAsOption(arg, itx)) continue;
            this.nonOptions.add(arg);
        }
    }

    private boolean tryAsOption(String arg, Iterator<String> itx) {
        String argSansParam = arg.contains("=") ? arg.substring(0, arg.indexOf("=")) : arg;
        OptionDefinition def = this.defsByStr.get(argSansParam);
        if (def == null) {
            return false;
        }
        Option opt = this.options.get(def.key);
        if (opt == null) {
            opt = new Option();
            this.options.put(def.key, opt);
        }
        opt.isEnabled = argSansParam.equals(def.enableVal);
        if (arg.contains("=")) {
            String params = arg.substring(arg.indexOf("=") + 1);
            for (String param : params.split(",")) {
                opt.addValue(param);
            }
        } else {
            for (int ii = 0; ii < def.numParams; ++ii) {
                opt.addValue(itx.next());
            }
        }
        return true;
    }

    public OptionDefinition getDefinition(Object key) {
        return this.defsByKey.get(key);
    }

    public List<OptionDefinition> getAllDefinitions() {
        return this.optionDefs;
    }

    public String getHelp() {
        StringBuilder sb = new StringBuilder(1024);
        for (OptionDefinition def : this.optionDefs) {
            sb.append("\n");
            if (def.type == OptionDefinition.Type.BINARY) {
                sb.append("    ").append(def.enableVal);
                if (def.enableByDefault) {
                    sb.append(" (default)");
                }
                sb.append("\n");
                if (!StringUtil.isEmpty(def.disableVal)) {
                    sb.append("    ").append(def.disableVal);
                    if (!def.enableByDefault) {
                        sb.append(" (default)");
                    }
                    sb.append("\n");
                }
            } else {
                sb.append("    ").append(def.enableVal);
                for (int ii = 0; ii < def.numParams; ++ii) {
                    if (ii == 0) {
                        sb.append("=PARAM").append(ii + 1);
                    } else {
                        sb.append(",PARAM").append(ii + 1);
                    }
                    sb.append("\n");
                }
            }
            sb.append("\n    ").append(def.description).append("\n");
        }
        return sb.toString();
    }

    public boolean isOptionEnabled(Object key) {
        Option opt = this.options.get(key);
        if (opt != null) {
            return opt.isEnabled;
        }
        OptionDefinition def = this.defsByKey.get(key);
        if (def != null) {
            return def.enableByDefault;
        }
        throw new IllegalArgumentException("unknown option key: " + key);
    }

    public List<Object> getOptions() {
        return new ArrayList<Object>(this.options.keySet());
    }

    public List<String> getOptionValues(Object key) {
        Option opt = this.options.get(key);
        if (opt == null || opt.values == null) {
            return Collections.emptyList();
        }
        return opt.values;
    }

    public List<String> getParameters() {
        return this.nonOptions;
    }

    public String shift() {
        if (this.shiftArgs.hasNext()) {
            return this.shiftArgs.next();
        }
        return null;
    }

    private static class Option {
        public List<String> values;
        public boolean isEnabled;

        private Option() {
        }

        public void addValue(String param) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.add(param);
        }
    }

    public static class OptionDefinition {
        private Type type;
        private Object key;
        private String enableVal;
        private String disableVal;
        private boolean enableByDefault;
        private int numParams;
        private String description;

        public OptionDefinition(Object key, String enableVal, String disableVal, boolean enableByDefault, String description) {
            this.type = Type.BINARY;
            this.key = key;
            this.enableVal = enableVal;
            this.disableVal = disableVal;
            this.enableByDefault = enableByDefault;
            this.numParams = 0;
            this.description = description;
        }

        public OptionDefinition(Object key, String enableVal, int numParams, String description) {
            this.type = Type.PARAMETERIZED;
            this.key = key;
            this.enableVal = enableVal;
            this.enableByDefault = false;
            this.numParams = numParams;
            this.description = description;
        }

        public Type getType() {
            return this.type;
        }

        public Object getKey() {
            return this.key;
        }

        public String getEnableVal() {
            return this.enableVal;
        }

        public String getDisableVal() {
            return this.disableVal;
        }

        public boolean isEnableByDefault() {
            return this.enableByDefault;
        }

        public int getNumParams() {
            return this.numParams;
        }

        public String getDescription() {
            return this.description;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            BINARY,
            PARAMETERIZED;

        }
    }
}

