/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.converter;

import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import org.w3c.dom.Element;

public class ConversionException
extends RuntimeException {
    private static final long serialVersionUID = 2L;
    private String _baseMessage;
    private String _field;
    private String _xpath;

    public ConversionException(String message) {
        super(message);
        this._baseMessage = message;
    }

    public ConversionException(String message, Throwable cause) {
        super(message, cause);
        this._baseMessage = message;
    }

    public ConversionException(String message, Element elem) {
        this(message, elem, null);
    }

    public ConversionException(String message, Element elem, Throwable cause) {
        super(ConversionException.constructMessage(message, DomUtil.getAbsolutePath(elem)), cause);
        this._xpath = DomUtil.getAbsolutePath(elem);
    }

    public ConversionException(String message, String field) {
        this(message, field, null);
    }

    public ConversionException(String message, String field, Throwable cause) {
        super(ConversionException.constructMessage(message, field), cause);
        this._baseMessage = message;
        this._field = field;
    }

    public ConversionException(ConversionException source, String field) {
        this(source._baseMessage, ConversionException.constructField(source._field, field), source.getCause());
        this.setStackTrace(source.getStackTrace());
    }

    public String getXPath() {
        return this._xpath;
    }

    public String getField() {
        return this._field;
    }

    private static String constructMessage(String baseMessage, String addition) {
        StringBuilder buf = new StringBuilder(baseMessage.length() + addition.length() + 3);
        buf.append(baseMessage).append(": ").append(addition);
        return buf.toString();
    }

    private static String constructField(String sourceField, String field) {
        if (sourceField == null) {
            return field;
        }
        StringBuilder buf = new StringBuilder(sourceField.length() + field.length() + 2);
        buf.append(field).append(".").append(sourceField);
        return buf.toString();
    }
}

