/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.converter.bean;

import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.ConversionException;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.bean.Bean2XmlOptions;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal.ConversionUtils;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal.TypeUtils;
import java.util.EnumSet;
import org.w3c.dom.Element;

public abstract class Bean2XmlAppenders {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapAppender
    extends BasicAppender {
        public MapAppender(Appender parent, Element node, Object nodeObject) {
            super(parent, node, nodeObject);
        }

        @Override
        public Element appendValue(String name, Class<?> klass, String value) {
            Element child = super.appendValue(this.determineName(name), klass, value);
            this.setMapKeyIfNeeded(child, name);
            return child;
        }

        @Override
        public Element appendContainer(String name, Class<?> klass) {
            Element child = super.appendContainer(this.determineName(name), klass);
            this.setMapKeyIfNeeded(child, name);
            return child;
        }

        private String determineName(String origName) {
            return this.isOptionSet(Bean2XmlOptions.MAP_KEYS_AS_ELEMENT_NAME) ? origName : "data";
        }

        private void setMapKeyIfNeeded(Element child, String origName) {
            if (child != null && !this.isOptionSet(Bean2XmlOptions.MAP_KEYS_AS_ELEMENT_NAME)) {
                ConversionUtils.setAttribute(child, "key", origName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexedAppender
    extends BasicAppender {
        private int _index = 0;

        public IndexedAppender(Appender parent, Element node, Object nodeObject) {
            super(parent, node, nodeObject);
        }

        @Override
        public Element appendValue(String name, Class<?> klass, String value) {
            Element child = super.appendValue(name, klass, value);
            if (child != null && this.isOptionSet(Bean2XmlOptions.USE_INDEX_ATTR)) {
                ConversionUtils.setAttribute(child, "index", String.valueOf(this._index++));
            }
            return child;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicAppender
    extends Appender {
        private Element _elem;

        public BasicAppender(Appender parent, Element elem, Object nodeObject) {
            super(parent, nodeObject);
            this._elem = elem;
        }

        @Override
        public Element appendValue(String name, Class<?> klass, String value) {
            if (this.shouldSkip(value)) {
                return null;
            }
            try {
                Element child = DomUtil.appendChildInheritNamespace(this._elem, name);
                this.setType(child, klass);
                this.setValue(child, value);
                return child;
            }
            catch (Exception ee) {
                throw new ConversionException("unable to append child: " + name, this._elem, (Throwable)ee);
            }
        }

        @Override
        public Element appendContainer(String name, Class<?> klass) {
            Element child = DomUtil.appendChildInheritNamespace(this._elem, name);
            this.setType(child, klass);
            return child;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectAppender
    extends Appender {
        private Element _elem;

        public DirectAppender(EnumSet<Bean2XmlOptions> options, Element elem, Object rootObj) {
            super(options, rootObj);
            this._elem = elem;
        }

        @Override
        public Element appendValue(String name, Class<?> klass, String value) {
            if (!this.shouldSkip(value)) {
                this.setType(this._elem, klass);
                this.setValue(this._elem, value);
            }
            return this._elem;
        }

        @Override
        public Element appendContainer(String name, Class<?> klass) {
            this.setType(this._elem, klass);
            return this._elem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Appender {
        private EnumSet<Bean2XmlOptions> _options;
        private Appender _parent;
        private Object _nodeObject;

        protected Appender(EnumSet<Bean2XmlOptions> options, Object rootObject) {
            this._options = options;
            this._nodeObject = rootObject;
        }

        protected Appender(Appender parent, Object nodeObject) {
            this(parent._options, nodeObject);
            this._parent = parent;
        }

        protected boolean isOptionSet(Bean2XmlOptions option) {
            return this._options.contains((Object)option);
        }

        protected boolean isCircularReference(Object obj) {
            return obj == null ? false : (obj instanceof String ? false : (obj instanceof Enum ? false : (obj.getClass().isPrimitive() ? false : (obj == this._nodeObject ? true : (this._parent != null ? this._parent.isCircularReference(obj) : false)))));
        }

        protected boolean shouldSkip(Object value) {
            if (value == null) {
                return !this.isOptionSet(Bean2XmlOptions.NULL_AS_EMPTY) && !this.isOptionSet(Bean2XmlOptions.NULL_AS_XSI_NIL);
            }
            if (this.isCircularReference(value)) {
                if (this.isOptionSet(Bean2XmlOptions.SKIP_CIRCULAR_REFERENCES)) {
                    return true;
                }
                throw new ConversionException("circular reference: " + value);
            }
            return false;
        }

        protected void setType(Element elem, Class<?> klass) {
            if (this.isOptionSet(Bean2XmlOptions.USE_TYPE_ATTR)) {
                TypeUtils.setType(elem, klass);
            }
        }

        public void overrideType(Element elem, String typedesc) {
            if (this.isOptionSet(Bean2XmlOptions.USE_TYPE_ATTR)) {
                ConversionUtils.setAttribute(elem, "type", typedesc);
            }
        }

        protected void setValue(Element elem, String value) {
            if (value != null) {
                DomUtil.setText(elem, value);
            } else if (this.isOptionSet(Bean2XmlOptions.NULL_AS_EMPTY)) {
                DomUtil.setText(elem, "");
            } else if (this.isOptionSet(Bean2XmlOptions.NULL_AS_XSI_NIL)) {
                ConversionUtils.setXsiNil(elem, true);
            }
        }

        public abstract Element appendValue(String var1, Class<?> var2, String var3);

        public abstract Element appendContainer(String var1, Class<?> var2);
    }
}

