/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.internal;

import eu.ha3.matmos.lib.net.sf.practicalxml.XmlException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;

public class TransformerFactoryHelper {
    private TransformerFactory _factory;
    private boolean _usePrologue;
    private String _encoding;
    private boolean _indent;
    private int _indentLevel;

    public TransformerFactoryHelper setPrologue() {
        this._factory = null;
        this._usePrologue = true;
        return this;
    }

    public TransformerFactoryHelper setPrologue(String encoding) {
        this._factory = null;
        this._usePrologue = true;
        this._encoding = encoding;
        return this;
    }

    public TransformerFactoryHelper setIndent(int indentLevel) {
        this._factory = null;
        this._indent = true;
        this._indentLevel = indentLevel;
        return this;
    }

    public Transformer newTransformer() {
        try {
            if (this._factory == null) {
                this._factory = TransformerFactory.newInstance();
                this.configIndent(this._factory);
            }
            Transformer xform = this._factory.newTransformer();
            this.configIndent(xform);
            this.configPrologue(xform);
            return xform;
        }
        catch (Exception e) {
            throw new XmlException("unable to configure transformer", e);
        }
    }

    private void configPrologue(Transformer xform) {
        xform.setOutputProperty("omit-xml-declaration", this._usePrologue ? "no" : "yes");
        if (this._encoding != null) {
            xform.setOutputProperty("encoding", this._encoding);
        }
    }

    private void configIndent(TransformerFactory fact) {
        if (!this._indent) {
            return;
        }
        if (!fact.getClass().getName().startsWith("org.apache.xalan")) {
            fact.setAttribute("indent-number", this._indentLevel);
        }
    }

    private void configIndent(Transformer xform) {
        xform.setOutputProperty("indent", this._indent ? "yes" : "no");
        if (xform.getClass().getName().startsWith("org.apache.xalan")) {
            xform.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", String.valueOf(this._indentLevel));
        }
    }
}

