/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.xpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;

public class FunctionResolver
implements XPathFunctionResolver,
Cloneable {
    private Map<QName, FunctionHolder> _table = new HashMap<QName, FunctionHolder>();

    public FunctionResolver addFunction(SelfDescribingFunction func) {
        FunctionHolder holder = this._table.get(func.getQName());
        if (holder == null) {
            holder = new FunctionHolder(func);
            this._table.put(func.getQName(), holder);
        } else {
            holder.put(func);
        }
        return this;
    }

    public FunctionResolver addFunction(XPathFunction func, QName name) {
        return this.addFunction(func, name, 0, Integer.MAX_VALUE);
    }

    public FunctionResolver addFunction(XPathFunction func, QName name, int argCount) {
        return this.addFunction(func, name, argCount, argCount);
    }

    public FunctionResolver addFunction(XPathFunction func, QName name, int minArgCount, int maxArgCount) {
        return this.addFunction(new StandardFunctionAdapter(func, name, minArgCount, maxArgCount));
    }

    public XPathFunction resolveFunction(QName functionName, int arity) {
        FunctionHolder holder = this._table.get(functionName);
        return holder != null ? holder.get(arity) : null;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FunctionResolver) {
            return this._table.equals(((FunctionResolver)obj)._table);
        }
        return false;
    }

    public final int hashCode() {
        return this._table.keySet().hashCode();
    }

    public String toString() {
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry<QName, FunctionHolder> fn : this._table.entrySet()) {
            QName name = fn.getKey();
            FunctionHolder holder = fn.getValue();
            StringBuilder sb = new StringBuilder(64);
            for (SelfDescribingFunction func : holder.getAll()) {
                sb.append("{").append(name.getNamespaceURI()).append("}").append(name.getLocalPart()).append("(").append(func.getMinArgCount()).append(":").append(func.getMaxArgCount()).append(")");
                items.add(sb.toString());
            }
        }
        return ((Object)items).toString();
    }

    public FunctionResolver clone() {
        try {
            FunctionResolver ret = (FunctionResolver)super.clone();
            ret._table = new HashMap<QName, FunctionHolder>(this._table);
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("should never be thrown unless class hierarchy is changed", e);
        }
    }

    private static class StandardFunctionAdapter
    extends AbstractSelfDescribingFunction {
        final XPathFunction _func;

        public StandardFunctionAdapter(XPathFunction func, QName name, int minArgCount, int maxArgCount) {
            super(name, minArgCount, maxArgCount);
            this._func = func;
        }

        public Object evaluate(List args) throws XPathFunctionException {
            return this._func.evaluate(args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionHolder {
        private SelfDescribingFunction _onlyOne;
        private TreeSet<SelfDescribingFunction> _hasMany;

        public FunctionHolder(SelfDescribingFunction initial) {
            this._onlyOne = initial;
        }

        public void put(SelfDescribingFunction func) {
            if (this._hasMany != null) {
                this._hasMany.remove(func);
                this._hasMany.add(func);
            } else if (this._onlyOne.equals(func)) {
                this._onlyOne = func;
            } else {
                this._hasMany = new TreeSet();
                this._hasMany.add(func);
                this._hasMany.add(this._onlyOne);
                this._onlyOne = null;
            }
        }

        public SelfDescribingFunction get(int arity) {
            if (this._onlyOne != null) {
                return this._onlyOne.isArityMatch(arity) ? this._onlyOne : null;
            }
            for (SelfDescribingFunction func : this._hasMany) {
                if (!func.isArityMatch(arity)) continue;
                return func;
            }
            return null;
        }

        public Set<SelfDescribingFunction> getAll() {
            if (this._onlyOne != null) {
                return new TreeSet<SelfDescribingFunction>(Arrays.asList(this._onlyOne));
            }
            return this._hasMany;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FunctionHolder) {
                FunctionHolder that = (FunctionHolder)obj;
                return this._onlyOne != null ? this._onlyOne.equals(that._onlyOne) : this._hasMany.equals(that._hasMany);
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static abstract class AbstractSelfDescribingFunction
    implements SelfDescribingFunction {
        private final QName _qname;
        private final int _minArgCount;
        private final int _maxArgCount;

        protected AbstractSelfDescribingFunction(QName qname, int minArgs, int maxArgs) {
            this._qname = qname;
            this._minArgCount = minArgs;
            this._maxArgCount = maxArgs;
        }

        public QName getQName() {
            return this._qname;
        }

        public String getNamespaceUri() {
            return this._qname.getNamespaceURI();
        }

        public String getName() {
            return this._qname.getLocalPart();
        }

        public int getMinArgCount() {
            return this._minArgCount;
        }

        public int getMaxArgCount() {
            return this._maxArgCount;
        }

        public boolean isMatch(QName qname, int arity) {
            return this._qname.equals(qname) && arity >= this._minArgCount && arity <= this._maxArgCount;
        }

        public boolean isArityMatch(int arity) {
            return arity >= this._minArgCount && arity <= this._maxArgCount;
        }

        public int compareTo(SelfDescribingFunction that) {
            int result = this.getNamespaceUri().compareTo(that.getNamespaceUri());
            if (result != 0) {
                return result < 0 ? -1 : 1;
            }
            result = this.getName().compareTo(that.getName());
            if (result != 0) {
                return result < 0 ? -1 : 1;
            }
            result = this.getMaxArgCount() - this.getMinArgCount() - (that.getMaxArgCount() - that.getMinArgCount());
            if (result != 0) {
                return result < 0 ? -1 : 1;
            }
            result = this.getMinArgCount() - that.getMinArgCount();
            if (result != 0) {
                return result < 0 ? -1 : 1;
            }
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AbstractSelfDescribingFunction) {
                AbstractSelfDescribingFunction that = (AbstractSelfDescribingFunction)obj;
                return this._qname.equals(that._qname) && this._minArgCount == that._minArgCount && this._maxArgCount == that._maxArgCount;
            }
            return false;
        }

        public final int hashCode() {
            return this._qname.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelfDescribingFunction
    extends XPathFunction,
    Comparable<SelfDescribingFunction> {
        public QName getQName();

        public String getNamespaceUri();

        public String getName();

        public int getMinArgCount();

        public int getMaxArgCount();

        public boolean isMatch(QName var1, int var2);

        public boolean isArityMatch(int var1);
    }
}

