/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.serialisation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Dynamic;
import eu.ha3.matmos.core.Knowledge;
import eu.ha3.matmos.core.Named;
import eu.ha3.matmos.core.Operator;
import eu.ha3.matmos.core.Possibilities;
import eu.ha3.matmos.core.ProviderCollection;
import eu.ha3.matmos.core.StreamInformation;
import eu.ha3.matmos.core.event.Event;
import eu.ha3.matmos.core.event.TimedEvent;
import eu.ha3.matmos.core.event.TimedEventInformation;
import eu.ha3.matmos.core.expansion.ExpansionIdentity;
import eu.ha3.matmos.core.logic.Condition;
import eu.ha3.matmos.core.logic.Junction;
import eu.ha3.matmos.core.logic.Machine;
import eu.ha3.matmos.core.sfx.BlockChangeSound;
import eu.ha3.matmos.core.sheet.SheetEntry;
import eu.ha3.matmos.core.sheet.SheetIndex;
import eu.ha3.matmos.serialisation.expansion.SerialCondition;
import eu.ha3.matmos.serialisation.expansion.SerialDynamic;
import eu.ha3.matmos.serialisation.expansion.SerialDynamicSheetIndex;
import eu.ha3.matmos.serialisation.expansion.SerialEvent;
import eu.ha3.matmos.serialisation.expansion.SerialList;
import eu.ha3.matmos.serialisation.expansion.SerialMachine;
import eu.ha3.matmos.serialisation.expansion.SerialMachineEvent;
import eu.ha3.matmos.serialisation.expansion.SerialMachineStream;
import eu.ha3.matmos.serialisation.expansion.SerialRoot;
import eu.ha3.matmos.serialisation.expansion.SerialSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonExpansions_EngineDeserializer {
    private static final Gson gson = new Gson();
    private List<Named> elements;
    private Knowledge knowledgeWorkstation;
    private ProviderCollection providers;
    private String UID;

    public Exception loadJson(String jasonString, ExpansionIdentity identity, Knowledge knowledge) {
        try {
            this.parseJsonUnsafe(jasonString, identity, knowledge);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e;
        }
    }

    public void loadSerial(SerialRoot root, ExpansionIdentity identity, Knowledge knowledge) {
        this.prepare(identity, knowledge);
        this.continueFromSerial(root, identity, knowledge);
    }

    public SerialRoot jsonToSerial(String jasonString) {
        return (SerialRoot)gson.fromJson((JsonElement)new JsonParser().parse(jasonString).getAsJsonObject(), SerialRoot.class);
    }

    private void prepare(ExpansionIdentity identity, Knowledge knowledge) {
        this.UID = identity.getUniqueName();
        this.knowledgeWorkstation = knowledge;
        this.elements = new ArrayList<Named>();
        this.providers = this.knowledgeWorkstation.obtainProviders();
    }

    private void parseJsonUnsafe(String jasonString, ExpansionIdentity identity, Knowledge knowledge) {
        SerialRoot root = this.jsonToSerial(jasonString);
        this.loadSerial(root, identity, knowledge);
    }

    private void continueFromSerial(SerialRoot root, ExpansionIdentity identity, Knowledge knowledge) {
        if (root.dynamic != null) {
            for (Map.Entry<String, Object> entry : root.dynamic.entrySet()) {
                ArrayList<SheetIndex> sheetIndexes = new ArrayList<SheetIndex>();
                for (SerialDynamicSheetIndex eelt : ((SerialDynamic)entry.getValue()).entries) {
                    sheetIndexes.add(new SheetEntry(eelt.sheet, eelt.index));
                }
                this.elements.add(new Dynamic(this.dynamicSheetHash(entry.getKey()), this.providers.getSheetCommander(), sheetIndexes));
            }
        }
        if (root.list != null) {
            for (Map.Entry<String, Object> entry : root.list.entrySet()) {
                this.elements.add(new Possibilities(entry.getKey(), this.asList(((SerialList)entry.getValue()).entries)));
            }
        }
        if (root.condition != null) {
            for (Map.Entry<String, Object> entry : root.condition.entrySet()) {
                String override;
                String indexNotComputed = ((SerialCondition)entry.getValue()).index;
                if (((SerialCondition)entry.getValue()).sheet.equals("_DYNAMIC")) {
                    indexNotComputed = this.dynamicSheetHash(indexNotComputed);
                }
                if ((override = knowledge.getConditionValueOverrides().get(entry.getKey())) != null) {
                    ((SerialCondition)entry.getValue()).value = override;
                }
                this.elements.add(new Condition(entry.getKey(), this.providers.getSheetCommander(), new SheetEntry(((SerialCondition)entry.getValue()).sheet, indexNotComputed), Operator.fromSerializedForm(((SerialCondition)entry.getValue()).symbol), ((SerialCondition)entry.getValue()).value));
            }
        }
        if (root.set != null) {
            for (Map.Entry<String, Object> entry : root.set.entrySet()) {
                this.elements.add(new Junction(entry.getKey(), this.providers.getCondition(), this.asList(((SerialSet)entry.getValue()).yes), this.asList(((SerialSet)entry.getValue()).no)));
            }
        }
        if (root.event != null) {
            for (Map.Entry<String, Object> entry : root.event.entrySet()) {
                this.elements.add(new Event(entry.getKey(), this.providers.getSoundRelay(), this.asList(((SerialEvent)entry.getValue()).path), ((SerialEvent)entry.getValue()).vol_min, ((SerialEvent)entry.getValue()).vol_max, ((SerialEvent)entry.getValue()).pitch_min, ((SerialEvent)entry.getValue()).pitch_max, ((SerialEvent)entry.getValue()).distance));
            }
        }
        if (root.machine != null) {
            for (Map.Entry<String, Object> entry : root.machine.entrySet()) {
                this.deserializeMachine(entry);
            }
        }
        if (root.soundeffects != null && root.soundeffects.blockchange != null) {
            root.soundeffects.blockchange.forEach((k, v) -> this.elements.add(new BlockChangeSound((String)k, this.providers.getSoundRelay(), v.when, v.blocks, v.sound, v.vol_min, v.vol_max, v.pitch_min, v.pitch_max)));
        }
        if (this.elements.size() > 0) {
            this.knowledgeWorkstation.addKnowledge(this.elements);
        }
    }

    private void deserializeMachine(Map.Entry<String, SerialMachine> entry) {
        boolean doubleMachine;
        SerialMachine serial = entry.getValue();
        List<SerialMachineEvent>[] serialEventLists = this.getSerialMachineEventList(entry, serial);
        List<SerialMachineStream>[] serialStreamLists = this.getSerialMachineStreamLists(entry, serial);
        boolean bl = doubleMachine = serialEventLists[1] != null || serialStreamLists[1] != null;
        if (doubleMachine) {
            if (serialEventLists[0] == null) {
                serialEventLists[0] = serialEventLists[1];
            } else if (serialEventLists[1] == null) {
                serialEventLists[1] = serialEventLists[0];
            }
            if (serialStreamLists[0] == null) {
                serialStreamLists[0] = serialStreamLists[1];
            } else if (serialStreamLists[1] == null) {
                serialStreamLists[1] = serialStreamLists[0];
            }
        }
        for (int m = 0; m < (doubleMachine ? 2 : 1); ++m) {
            MachineType type = !doubleMachine ? MachineType.NORMAL : (m == 0 ? MachineType.INDOOR : MachineType.OUTDOOR);
            this.deserializeMachineFromLists(entry, serial, serialEventLists[m], serialStreamLists[m], type);
        }
    }

    private void deserializeMachineFromLists(Map.Entry<String, SerialMachine> entry, SerialMachine serial, List<SerialMachineEvent> serialEventList, List<SerialMachineStream> serialStreamList, MachineType type) {
        ArrayList<TimedEvent> events = new ArrayList<TimedEvent>();
        if (serialEventList != null) {
            serialEventList.forEach(x -> events.add(new TimedEvent(this.providers.getEvent(), (SerialMachineEvent)x)));
        }
        ArrayList<StreamInformation> streamList = new ArrayList<StreamInformation>();
        boolean normal = type == MachineType.NORMAL;
        boolean indoor = type == MachineType.INDOOR;
        String machineName = entry.getKey();
        if (!normal) {
            machineName = machineName + (indoor ? " (Indoor)" : " (Outdoor)");
        }
        if (serialStreamList != null) {
            for (SerialMachineStream sms : serialStreamList) {
                streamList.add(new StreamInformation(machineName, this.providers.getMachine(), this.providers.getReferenceTime(), this.providers.getSoundRelay(), sms.path, sms.vol, sms.pitch, serial.delay_fadein, serial.delay_fadeout, serial.fadein, serial.fadeout, sms.looping, sms.pause, sms.underwater));
            }
        }
        TimedEventInformation tie = null;
        if (!events.isEmpty()) {
            tie = new TimedEventInformation(machineName, this.providers.getMachine(), this.providers.getReferenceTime(), events, serial.delay_fadein, serial.delay_fadeout, serial.fadein, serial.fadeout);
        }
        if (tie != null || streamList != null) {
            List<String> allowList = this.asList(serial.allow);
            List<String> restrictList = this.asList(serial.restrict);
            if (!normal) {
                if (!serial.play_deep_indoors) {
                    restrictList.add("_DEEP_INDOORS");
                    if (indoor) {
                        restrictList.add("_OUTDOORS");
                        restrictList.add("!_INDOORS");
                    } else {
                        restrictList.add("!_OUTDOORS");
                        restrictList.add("_INDOORS");
                    }
                } else if (indoor) {
                    restrictList.add("_OUTDOORS");
                } else {
                    restrictList.add("_INDOORS");
                    restrictList.add("_DEEP_INDOORS");
                }
            }
            Machine element = new Machine(machineName, this.providers.getJunction(), allowList, restrictList, tie, streamList);
            this.elements.add(element);
        }
    }

    private List<SerialMachineEvent>[] getSerialMachineEventList(Map.Entry<String, SerialMachine> entry, SerialMachine serial) {
        ArrayList[] eventList = new ArrayList[2];
        if (serial.event_pair != null) {
            if (serial.event != null) {
                Matmos.LOGGER.warn("Machine " + entry.getKey() + " has both 'event' and 'event_pair' defined. Ignoring 'event'.");
            }
            eventList[0] = serial.event_pair.indoor;
            eventList[1] = serial.event_pair.outdoor;
        } else if (serial.event != null) {
            eventList[0] = serial.event;
        }
        return eventList;
    }

    private List<SerialMachineStream>[] getSerialMachineStreamLists(Map.Entry<String, SerialMachine> entry, SerialMachine serial) {
        ArrayList[] smsLists = new ArrayList[2];
        if (serial.stream_pair != null) {
            if (serial.stream != null) {
                Matmos.LOGGER.warn("Machine " + entry.getKey() + " has both 'stream' and 'stream_pair' defined. Ignoring 'stream'.");
            }
            smsLists[0] = serial.stream_pair.indoor;
            smsLists[1] = serial.stream_pair.outdoor;
        }
        if (serial.stream != null) {
            smsLists[0] = new ArrayList();
            ArrayList<Object> smsObjectList = new ArrayList<Object>();
            if (serial.stream instanceof Map) {
                smsObjectList.add(serial.stream);
            } else if (serial.stream instanceof List) {
                for (Object e : (List)serial.stream) {
                    smsObjectList.add(e);
                }
            }
            for (Object e : smsObjectList) {
                SerialMachineStream sms = (SerialMachineStream)gson.fromJson(gson.toJson(e), SerialMachineStream.class);
                smsLists[0].add(sms);
            }
        }
        return smsLists;
    }

    private String dynamicSheetHash(String name) {
        return this.UID.hashCode() % 1000 + "_" + name;
    }

    private <T> List<T> asList(Collection<T> thing) {
        return new ArrayList<T>(thing);
    }

    static enum MachineType {
        NORMAL,
        INDOOR,
        OUTDOOR;

    }
}

