/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.serialisation;

import eu.ha3.matmos.core.Operator;
import eu.ha3.matmos.core.sheet.SheetEntry;
import eu.ha3.matmos.core.sheet.SheetIndex;
import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import eu.ha3.matmos.serialisation.LegacySheetIndex_Engine0to1;
import eu.ha3.matmos.serialisation.expansion.SerialCondition;
import eu.ha3.matmos.serialisation.expansion.SerialDynamic;
import eu.ha3.matmos.serialisation.expansion.SerialDynamicSheetIndex;
import eu.ha3.matmos.serialisation.expansion.SerialEvent;
import eu.ha3.matmos.serialisation.expansion.SerialList;
import eu.ha3.matmos.serialisation.expansion.SerialMachine;
import eu.ha3.matmos.serialisation.expansion.SerialMachineEvent;
import eu.ha3.matmos.serialisation.expansion.SerialMachineStream;
import eu.ha3.matmos.serialisation.expansion.SerialRoot;
import eu.ha3.matmos.serialisation.expansion.SerialSet;
import eu.ha3.matmos.util.MAtUtil;
import eu.ha3.matmos.util.math.Numbers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Deprecated
public class LegacyXMLExpansions_Engine1 {
    private static final String AS_ITEM = "__AS_ITEM";
    private static final String AS_BLOCK = "__AS_BLOCK";
    private static final String NAME = "name";
    private static final String LIST = "list";
    private static final String CONDITION = "condition";
    private static final String SHEET = "sheet";
    private static final String KEY = "key";
    private static final String DYNAMICKEY = "dynamickey";
    private static final String SYMBOL = "symbol";
    private static final String CONSTANT = "constant";
    private static final String SET = "set";
    private static final String TRUEPART = "truepart";
    private static final String FALSEPART = "falsepart";
    private static final String EVENT = "event";
    private static final String VOLMIN = "volmin";
    private static final String VOLMAX = "volmax";
    private static final String PITCHMIN = "pitchmin";
    private static final String PITCHMAX = "pitchmax";
    private static final String METASOUND = "metasound";
    private static final String PATH = "path";
    private static final String MACHINE = "machine";
    private static final String ALLOW = "allow";
    private static final String RESTRICT = "restrict";
    private static final String DYNAMIC = "dynamic";
    private static final String ENTRY = "entry";
    private static final String EVENTTIMED = "eventtimed";
    private static final String EVENTNAME = "eventname";
    private static final String VOLMOD = "volmod";
    private static final String PITCHMOD = "pitchmod";
    private static final String DELAYSTART = "delaystart";
    private static final String DELAYMIN = "delaymin";
    private static final String DELAYMAX = "delaymax";
    private static final String STREAM = "stream";
    private static final String VOLUME = "volume";
    private static final String PITCH = "pitch";
    private static final String FADEINTIME = "fadeintime";
    private static final String FADEOUTTIME = "fadeouttime";
    private static final String DELAYBEFOREFADEIN = "delaybeforefadein";
    private static final String DELAYBEFOREFADEOUT = "delaybeforefadeout";
    private static final String ISLOOPING = "islooping";
    private static final String ISUSINGPAUSE = "isusingpause";
    private Map<String, String> scanDicts = new HashMap<String, String>();
    private SerialRoot root;
    private Map<String, DynamicElementSerialiser> serialisers = new HashMap<String, DynamicElementSerialiser>();

    public LegacyXMLExpansions_Engine1() {
        this.serialisers.put(DYNAMIC, this::parseXML_1_dynamic);
        this.serialisers.put(LIST, this::parseXML_2_list);
        this.serialisers.put(CONDITION, this::parseXML_3_condition);
        this.serialisers.put(SET, this::parseXML_4_set);
        this.serialisers.put(EVENT, this::parseXML_5_event);
        this.serialisers.put(MACHINE, this::parseXML_6_machine);
        this.scanDicts.put("LargeScan", "scan_large");
        this.scanDicts.put("LargeScanPerMil", "scan_large_p1k");
        this.scanDicts.put("SmallScan", "scan_small");
        this.scanDicts.put("SmallScanPerMil", "scan_small_p1k");
        this.scanDicts.put("ContactScan", "scan_contact");
    }

    public SerialRoot loadXMLtoSerial(Document doc) {
        this.root = new SerialRoot();
        try {
            this.parseXMLtoSerial(doc);
            return this.root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SerialRoot();
        }
    }

    private String asBlock(int il) {
        Block block = Block.func_149729_e((int)il);
        if (block == null) {
            return null;
        }
        return MAtUtil.nameOf(block);
    }

    private String asBlock(String longFloatSimplificated) {
        if (longFloatSimplificated == null) {
            return null;
        }
        Long l = Numbers.toLong(longFloatSimplificated);
        if (l == null) {
            return null;
        }
        return this.asBlock((int)l.longValue());
    }

    private String asItem(int il) {
        Item item = Item.func_150899_d((int)il);
        if (item == null) {
            return null;
        }
        return MAtUtil.nameOf(item);
    }

    private String asItem(String longFloatSimplificated) {
        if (longFloatSimplificated == null) {
            return null;
        }
        Long l = Numbers.toLong(longFloatSimplificated);
        if (l == null) {
            return null;
        }
        return this.asItem((int)l.longValue());
    }

    private String eltString(String tagName, Element ele) {
        return this.textOf(DomUtil.getChild(ele, tagName));
    }

    private SerialMachineEvent inscriptXMLeventTimed(Element specs) {
        SerialMachineEvent sme = new SerialMachineEvent();
        sme.event = this.eltString(EVENTNAME, specs);
        sme.vol_mod = this.toFloat(this.eltString(VOLMOD, specs));
        sme.pitch_mod = this.toFloat(this.eltString(PITCHMOD, specs));
        sme.delay_min = this.toFloat(this.eltString(DELAYMIN, specs));
        sme.delay_max = this.toFloat(this.eltString(DELAYMAX, specs));
        sme.delay_start = this.toFloat(this.eltString(DELAYSTART, specs));
        return sme;
    }

    private float toFloat(String value) {
        return value != null ? Float.parseFloat(value) : 1.0f;
    }

    private SerialMachineStream inscriptXMLstream(Element specs, SerialMachine machine) {
        SerialMachineStream sms = new SerialMachineStream();
        sms.path = this.eltString(PATH, specs);
        sms.vol = this.toFloat(this.eltString(VOLUME, specs));
        sms.pitch = this.toFloat(this.eltString(PITCH, specs));
        machine.fadein = this.toFloat(this.eltString(FADEINTIME, specs));
        machine.fadeout = this.toFloat(this.eltString(FADEOUTTIME, specs));
        machine.delay_fadein = this.toFloat(this.eltString(DELAYBEFOREFADEIN, specs));
        machine.delay_fadeout = this.toFloat(this.eltString(DELAYBEFOREFADEOUT, specs));
        sms.looping = this.toInt(this.eltString(ISLOOPING, specs)) == 1;
        sms.pause = this.toInt(this.eltString(ISUSINGPAUSE, specs)) == 1;
        return sms;
    }

    private String nameOf(Element element) {
        if (element == null) {
            return null;
        }
        Node nameNode = element.getAttributes().getNamedItem(NAME);
        if (nameNode == null) {
            return null;
        }
        return nameNode.getNodeValue();
    }

    private void parseXMLtoSerial(Document doc) throws XPathExpressionException, DOMException {
        Element elt = doc.getDocumentElement();
        DomUtil.removeEmptyTextRecursive(elt);
        for (Map.Entry<String, DynamicElementSerialiser> entry : this.serialisers.entrySet()) {
            for (Element capsule : DomUtil.getChildren(elt, entry.getKey())) {
                String name = this.nameOf(capsule);
                if (name == null) continue;
                entry.getValue().parseXML(capsule, name);
            }
        }
    }

    private void parseXML_1_dynamic(Element capsule, String name) {
        SerialDynamic dynamic = new SerialDynamic();
        for (Element eelt : DomUtil.getChildren(capsule, ENTRY)) {
            SerialDynamicSheetIndex sdsi = new SerialDynamicSheetIndex();
            String sheet = eelt.getAttributes().getNamedItem(SHEET).getNodeValue();
            String index = this.textOf(eelt);
            if (sheet.contains("Scan")) {
                index = this.recomputeBlockName(index);
                sheet = this.recomputeScanSheetName(sheet);
            }
            LegacySheetIndex_Engine0to1 si = new LegacySheetIndex_Engine0to1(sheet, index);
            sdsi.sheet = si.getSheet();
            sdsi.index = si.getIndex();
            dynamic.entries.add(sdsi);
        }
        this.root.dynamic.put(name, dynamic);
    }

    private void parseXML_2_list(Element capsule, String name) {
        SerialList list = new SerialList();
        SerialList asItem = new SerialList();
        SerialList asBlock = new SerialList();
        for (Element eelt : DomUtil.getChildren(capsule, CONSTANT)) {
            list.entries.add(this.textOf(eelt));
            Long l = Numbers.toLong(this.textOf(eelt));
            if (l == null) continue;
            int il = (int)l.longValue();
            if (this.asBlock(il) != null) {
                asBlock.entries.add(this.asBlock(il));
            }
            if (this.asItem(il) == null) continue;
            asItem.entries.add(this.asItem(il));
        }
        this.root.list.put(name, list);
        this.root.list.put(name + AS_BLOCK, asBlock);
        this.root.list.put(name + AS_ITEM, asItem);
    }

    private void parseXML_3_condition(Element capsule, String name) {
        String sheetNotComputed = this.eltString(SHEET, capsule);
        String indexNotComputed = this.eltString(KEY, capsule);
        String dynamicIndexXX = this.eltString(DYNAMICKEY, capsule);
        String symbol = this.eltString(SYMBOL, capsule);
        String value = this.eltString(CONSTANT, capsule);
        String listValueXX = this.eltString(LIST, capsule);
        boolean dynamic = false;
        if (dynamicIndexXX != null) {
            sheetNotComputed = "_DYNAMIC";
            indexNotComputed = dynamicIndexXX;
            dynamic = true;
        }
        if (listValueXX != null) {
            value = listValueXX;
        }
        if (sheetNotComputed.contains("Scan")) {
            indexNotComputed = this.recomputeBlockName(indexNotComputed);
            sheetNotComputed = this.recomputeScanSheetName(sheetNotComputed);
        }
        SheetIndex si = !dynamic ? new LegacySheetIndex_Engine0to1(sheetNotComputed, indexNotComputed) : new SheetEntry(sheetNotComputed, indexNotComputed);
        this.root.condition.put(name, new SerialCondition(si, Operator.fromSymbol(symbol).getSerializedForm(), value));
        if (si instanceof LegacySheetIndex_Engine0to1) {
            if (((LegacySheetIndex_Engine0to1)si).isBlock() && this.asBlock(value) != null) {
                this.root.condition.put(name + AS_BLOCK, new SerialCondition(si, Operator.fromSymbol(symbol).getSerializedForm(), this.asBlock(value)));
            }
            if (((LegacySheetIndex_Engine0to1)si).isItem() && this.asItem(value) != null) {
                this.root.condition.put(name + AS_ITEM, new SerialCondition(si, Operator.fromSymbol(symbol).getSerializedForm(), this.asItem(value)));
            }
        }
    }

    private void parseXML_4_set(Element capsule, String name) {
        SerialSet set = new SerialSet();
        for (Element eelt : DomUtil.getChildren(capsule, TRUEPART)) {
            set.yes.add(this.textOf(eelt));
        }
        for (Element eelt : DomUtil.getChildren(capsule, FALSEPART)) {
            set.no.add(this.textOf(eelt));
        }
        this.root.set.put(name, set);
    }

    private void parseXML_5_event(Element capsule, String name) {
        SerialEvent event = new SerialEvent();
        String volmin = this.eltString(VOLMIN, capsule);
        String volmax = this.eltString(VOLMAX, capsule);
        String pitchmin = this.eltString(PITCHMIN, capsule);
        String pitchmax = this.eltString(PITCHMAX, capsule);
        String metasound = this.eltString(METASOUND, capsule);
        event.vol_min = volmin != null ? Float.parseFloat(volmin) : 1.0f;
        event.vol_max = volmax != null ? Float.parseFloat(volmax) : 1.0f;
        event.pitch_min = pitchmin != null ? Float.parseFloat(pitchmin) : 1.0f;
        event.pitch_max = pitchmax != null ? Float.parseFloat(pitchmax) : 1.0f;
        event.distance = metasound != null ? this.toInt(metasound) : 0;
        for (Element eelt : DomUtil.getChildren(capsule, PATH)) {
            event.path.add(this.textOf(eelt));
        }
        this.root.event.put(name, event);
    }

    private void parseXML_6_machine(Element capsule, String name) {
        SerialMachine machine = new SerialMachine();
        SerialMachineStream stream = null;
        for (Element eelt : DomUtil.getChildren(capsule, STREAM)) {
            stream = this.inscriptXMLstream(eelt, machine);
        }
        if (stream != null) {
            ArrayList<SerialMachineStream> streamList = new ArrayList<SerialMachineStream>();
            streamList.add(stream);
            machine.stream = streamList;
        } else {
            machine.delay_fadein = 0.0f;
            machine.delay_fadeout = 0.0f;
            machine.fadein = 0.0f;
            machine.fadeout = 0.0f;
        }
        for (Element eelt : DomUtil.getChildren(capsule, EVENTTIMED)) {
            machine.event.add(this.inscriptXMLeventTimed(eelt));
        }
        for (Element eelt : DomUtil.getChildren(capsule, ALLOW)) {
            machine.allow.add(this.textOf(eelt));
        }
        for (Element eelt : DomUtil.getChildren(capsule, RESTRICT)) {
            machine.restrict.add(this.textOf(eelt));
        }
        this.root.machine.put(name, machine);
    }

    private String recomputeBlockName(String index) {
        Long l = Numbers.toLong(index);
        if (l != null && l < 256L) {
            Object o = Block.field_149771_c.func_148754_a((int)l.longValue());
            if (o != null && o instanceof Block) {
                index = MAtUtil.nameOf((Block)o);
            } else {
                System.err.println("??? Failed to convert block with index " + index);
            }
        } else {
            System.err.println("??? Failed to convert block with index " + index + " out of bounds?");
        }
        return index;
    }

    private String recomputeScanSheetName(String sheet) {
        if (this.scanDicts.containsKey(sheet)) {
            return this.scanDicts.get(sheet);
        }
        System.err.println("Scan sheet has no equivalent: " + this.scanDicts);
        return sheet;
    }

    private String textOf(Element ele) {
        if (ele == null || ele.getFirstChild() == null) {
            return null;
        }
        return ele.getFirstChild().getNodeValue();
    }

    private int toInt(String source) {
        try {
            return Integer.parseInt(source);
        }
        catch (NumberFormatException e) {
            return (int)Float.parseFloat(source);
        }
    }

    @FunctionalInterface
    protected static interface DynamicElementSerialiser {
        public void parseXML(Element var1, String var2);
    }
}

