/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface BetterStreams<T> {
    public static <T> BetterStreams<T> of(Collection<? extends T> iterable) {
        return () -> iterable.stream();
    }

    @SafeVarargs
    public static <T> BetterStreams<T> of(Collection<? extends T> ... collections) {
        return () -> Stream.of(collections).flatMap(Collection::stream);
    }

    @SafeVarargs
    public static <T> BetterStreams<T> of(Map<?, ? extends T> ... maps) {
        return () -> Stream.of(maps).map(Map::values).flatMap(Collection::stream);
    }

    public Stream<? extends T> s();

    default public BetterStreams<T> unique() {
        return () -> this.s().distinct();
    }

    default public <V> BetterStreams<V> flatten(Function<? super T, Collection<V>> convert) {
        return () -> this.s().flatMap(a -> ((Collection)convert.apply(a)).stream());
    }

    default public <V> BetterStreams<V> map(Function<? super T, V> convert) {
        return () -> this.s().map(convert);
    }

    default public BetterStreams<T> join(Collection<? extends T> iterable) {
        return () -> Stream.concat(this.s(), iterable.stream());
    }

    default public BetterStreams<T> join(Map<?, ? extends T> map) {
        return () -> Stream.concat(this.s(), map.values().stream());
    }

    default public BetterStreams<T> filter(Predicate<? super T> test) {
        return () -> this.s().filter(test);
    }

    default public List<T> asList() {
        return this.s().collect(Collectors.toList());
    }

    default public Set<T> asSet() {
        return this.s().collect(Collectors.toSet());
    }

    default public void forEach(Consumer<? super T> action) {
        this.s().forEach(action);
    }
}

