/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultConfigHelper {
    private final String MODID;
    private final Logger LOGGER;

    public DefaultConfigHelper(String modid) {
        this.MODID = modid;
        this.LOGGER = LogManager.getLogger((String)this.MODID);
    }

    public Path getDefaultConfigFilePath(Path relPath) throws IOException {
        String resourceRelPath = Paths.get("assets/" + this.MODID + "/default_config/", new String[0]).resolve(relPath).toString().replace('\\', '/');
        URL resourceURL = new Object(){}.getClass().getEnclosingClass().getClassLoader().getResource(resourceRelPath);
        switch (resourceURL.getProtocol()) {
            case "jar": {
                String urlString = resourceURL.getPath();
                int lastExclamation = urlString.lastIndexOf(33);
                String newURLString = urlString.substring(0, lastExclamation);
                return FileSystems.newFileSystem(new File(URI.create(newURLString)).toPath(), null).getPath(resourceRelPath, new String[0]);
            }
            case "file": {
                return new File(URI.create(resourceURL.toString())).toPath();
            }
        }
        return null;
    }

    private void copyDefaultConfigFile(Path src, Path dest, boolean print) throws IOException {
        Files.createDirectories(this.getParentSafe(dest), new FileAttribute[0]);
        if (print) {
            this.LOGGER.debug("Copying " + src + " -> " + dest);
        }
        Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean createDefaultConfigFileIfMissing(File destFile, boolean overwrite) {
        return this.createDefaultConfigFileIfMissing(destFile, overwrite, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createDefaultConfigFileIfMissing(File destFile, boolean overwrite, boolean print) {
        Path destConfigFolderPath = Paths.get(new File(Launch.minecraftHome, "config").getPath(), new String[0]);
        Path destFilePath = Paths.get(destFile.getPath(), new String[0]);
        Path destRelPath = destConfigFolderPath.relativize(destFilePath);
        if (destFilePath.startsWith(destConfigFolderPath)) {
            try {
                Path srcConfigPath = this.getDefaultConfigFilePath(destRelPath).toAbsolutePath();
                if (Files.isRegularFile(srcConfigPath, new LinkOption[0])) {
                    if (destFile.exists() && !overwrite) return true;
                    this.copyDefaultConfigFile(srcConfigPath, destFile.toPath(), print);
                    return true;
                }
                if (!Files.isDirectory(srcConfigPath, new LinkOption[0])) return true;
                Files.createDirectories(Paths.get(destFile.getPath(), new String[0]), new FileAttribute[0]);
                for (Path srcChildPath : (Path[])Files.walk(srcConfigPath, new FileVisitOption[0]).toArray(Path[]::new)) {
                    Path destPath = destFile.toPath().resolve(srcConfigPath.relativize(srcChildPath).toString());
                    if (srcChildPath.equals(srcConfigPath) || !srcChildPath.startsWith(srcConfigPath) || this.createDefaultConfigFileIfMissing(destPath.toFile(), overwrite, print)) continue;
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to create default config file for " + destRelPath.toString() + ": " + e.getMessage());
                return false;
            }
        } else {
            this.LOGGER.debug("Invalid argument for creating default config file: " + destRelPath.toString() + " (file is not in the config directory)");
            return false;
        }
    }

    public Path getParentSafe(Path p) {
        if (p == null || p.getParent() == null) {
            return Paths.get("", new String[0]);
        }
        return p.getParent();
    }
}

