/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.util;

import eu.ha3.matmos.Matmos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TickProfiler {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty("matmos.tickProfiler", "false"));
    private static long firstFrameStart;
    private static long framesMeasured;
    private static long lastTickStart;
    private static long tickStart;
    private static long sectionStart;
    private static long totalSectionTime;
    private static List<Long> sectionTimes;
    private static List<Long> sortedSectionTimes;

    public static void start() {
        TickProfiler.start(false);
    }

    public static void start(boolean newFrame) {
        if (!ENABLED) {
            return;
        }
        if (newFrame) {
            lastTickStart = tickStart;
        }
        sectionStart = System.nanoTime();
        if (newFrame) {
            tickStart = sectionStart;
            if (firstFrameStart == 0L) {
                firstFrameStart = sectionStart;
            }
        }
        if (lastTickStart != 0L && newFrame) {
            sectionTimes.add(totalSectionTime);
            totalSectionTime = 0L;
            int interval = 400;
            int tickTime = 50000000;
            if (framesMeasured++ % (long)interval == 0L) {
                sortedSectionTimes.clear();
                sortedSectionTimes.addAll(sectionTimes);
                Collections.sort(sortedSectionTimes);
                long avg50 = 0L;
                int counted50 = 0;
                for (int i = (int)((float)sectionTimes.size() * 0.5f); i < sectionTimes.size(); ++i) {
                    avg50 += sectionTimes.get(i).longValue();
                    ++counted50;
                }
                long median = sortedSectionTimes.get(sortedSectionTimes.size() / 2);
                Matmos.LOGGER.info("uptime: " + (double)(sectionStart - firstFrameStart) / 1.0E9 + "s median: " + (double)median / (double)tickTime + " avg50%: " + (double)avg50 / (double)counted50 / (double)tickTime);
            }
        }
    }

    public static void end() {
        if (!ENABLED) {
            return;
        }
        long sectionEnd = System.nanoTime();
        totalSectionTime += sectionEnd - sectionStart;
    }

    static {
        sectionTimes = new ArrayList<Long>();
        sortedSectionTimes = new ArrayList<Long>();
    }
}

