/*
 * Decompiled with CFR 0.152.
 */
package mod.icarus.crimsonrevelations.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import mod.icarus.crimsonrevelations.config.CRConfig;
import mod.icarus.crimsonrevelations.init.CRItems;
import mod.icarus.crimsonrevelations.item.CRItemManaBean;
import mod.icarus.crimsonrevelations.tile.CRTileManaPod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.internal.WorldCoordinates;

public class CRBlockManaPod
extends Block
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)8);
    public static float W1 = 0.0625f;
    public static float W2 = 0.125f;
    public static float W3 = 0.1875f;
    public static float W4 = 0.25f;
    public static float W5 = 0.3125f;
    public static float W6 = 0.375f;
    public static float W7 = 0.4375f;
    public static float W8 = 0.5f;
    public static float W9 = 0.5625f;
    public static float W10 = 0.625f;
    public static float W11 = 0.6875f;
    public static float W12 = 0.75f;
    public static float W13 = 0.8125f;
    public static float W14 = 0.875f;
    public static float W15 = 0.9375f;
    static HashMap<WorldCoordinates, Aspect> st = new HashMap();

    public CRBlockManaPod() {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        this.func_185496_a(state, worldIn, pos);
        return super.func_180646_a(state, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int l = this.func_176201_c(state);
        switch (l) {
            case 0: {
                return new AxisAlignedBB(0.25, (double)W12, 0.25, 0.75, 1.0, 0.75);
            }
            case 1: {
                return new AxisAlignedBB(0.25, (double)W10, 0.25, 0.75, 1.0, 0.75);
            }
            case 2: {
                return new AxisAlignedBB(0.25, (double)W8, 0.25, 0.75, 1.0, 0.75);
            }
            case 3: {
                return new AxisAlignedBB(0.25, (double)W6, 0.25, 0.75, 1.0, 0.75);
            }
            case 4: {
                return new AxisAlignedBB(0.25, (double)W5, 0.25, 0.75, 1.0, 0.75);
            }
            case 5: {
                return new AxisAlignedBB(0.25, (double)W4, 0.25, 0.75, 1.0, 0.75);
            }
            case 6: {
                return new AxisAlignedBB(0.25, (double)W3, 0.25, 0.75, 1.0, 0.75);
            }
            case 7: {
                return new AxisAlignedBB(0.25, (double)W2, 0.25, 0.75, 1.0, 0.75);
            }
        }
        return new AxisAlignedBB(0.25, (double)W2, 0.25, 0.75, 1.0, 0.75);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        this.func_185496_a(state, (IBlockAccess)worldIn, pos);
        return super.func_180640_a(state, worldIn, pos);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canBlockStay(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        } else if (world.field_73012_v.nextInt(30) == 0) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof CRTileManaPod) {
                ((CRTileManaPod)tile).checkGrowth();
            }
            st.remove(new WorldCoordinates(pos, world.field_73011_w.getDimension()));
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        Biome biome = world.func_180494_b(pos);
        boolean magicBiome = false;
        if (biome != null) {
            magicBiome = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
        }
        Block i1 = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return magicBiome && (i1 instanceof BlockLog || i1 == BlocksTC.logGreatwood || i1 == BlocksTC.logSilverwood);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing facing) {
        Biome biome = world.func_180494_b(pos);
        boolean magicBiome = biome != null && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        boolean isLog = blockAbove instanceof BlockLog || blockAbove == BlocksTC.logGreatwood || blockAbove == BlocksTC.logSilverwood;
        return facing == EnumFacing.DOWN && isLog && magicBiome;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_176201_c(state);
    }

    public void func_189540_a(IBlockState state, World par1World, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(par1World, pos, state)) {
            this.func_176226_b(par1World, pos, state, 0);
            par1World.func_175698_g(pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof CRTileManaPod && ((CRTileManaPod)tile).aspect != null) {
            st.put(new WorldCoordinates(pos, world.field_73011_w.getDimension()), ((CRTileManaPod)tile).aspect);
        }
        super.func_180663_b(world, pos, state);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        int metadata = this.func_176201_c(state);
        if (metadata < 2) {
            return dropped;
        }
        int b0 = 1;
        if (metadata >= 7 && ((World)world).field_73012_v.nextFloat() > 0.33f) {
            b0 = 2;
        }
        Aspect aspect = Aspect.PLANT;
        if (st.containsKey(new WorldCoordinates(pos, ((World)world).field_73011_w.getDimension()))) {
            aspect = st.get(new WorldCoordinates(pos, ((World)world).field_73011_w.getDimension()));
        } else {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof CRTileManaPod && ((CRTileManaPod)tile).aspect != null) {
                aspect = ((CRTileManaPod)tile).aspect;
            }
        }
        for (int k1 = 0; k1 < b0; ++k1) {
            ItemStack i = new ItemStack((Item)CRItems.MANA_BEAN);
            ((CRItemManaBean)i.func_77973_b()).setAspects(i, new AspectList().add(aspect, CRConfig.general_settings.MANA_BEAN_ASPECT_COUNT));
            dropped.add(i);
        }
        st.remove(new WorldCoordinates(pos, ((World)world).field_73011_w.getDimension()));
        return dropped;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return CRItems.MANA_BEAN.func_190903_i();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150899_d((int)0);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new CRTileManaPod();
    }

    public boolean func_176473_a(World world, BlockPos blockPos, IBlockState iBlockState, boolean b) {
        return (Integer)iBlockState.func_177229_b((IProperty)AGE) < 8;
    }

    public boolean func_180670_a(World world, Random random, BlockPos blockPos, IBlockState iBlockState) {
        return false;
    }

    public void func_176474_b(World world, Random random, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)), 8);
    }
}

