/*
 * Decompiled with CFR 0.152.
 */
package mod.icarus.crimsonrevelations.entity.projectile;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityPrimalArrow
extends EntityArrow
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> ARROW_TYPE = EntityDataManager.func_187226_a(EntityPrimalArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private Item item;
    private int knockbackStrength;
    private int ticksInGround = 0;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile = Blocks.field_150350_a;
    private int inData = 0;

    public EntityPrimalArrow(World world) {
        super(world);
    }

    public EntityPrimalArrow(World world, double x, double y, double z, Item arrow) {
        super(world, x, y, z);
        this.item = arrow;
    }

    public EntityPrimalArrow(World world, EntityLivingBase shooter, Item arrow) {
        super(world, shooter);
        this.item = arrow;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ARROW_TYPE, (Object)0);
    }

    public int getArrowType() {
        return (Integer)this.field_70180_af.func_187225_a(ARROW_TYPE);
    }

    public void setArrowType(int type) {
        this.field_70180_af.func_187227_b(ARROW_TYPE, (Object)type);
    }

    public void func_70240_a(int knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    protected ItemStack func_184550_j() {
        return new ItemStack(this.item, 1, 0);
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float hVelocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)hVelocity) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70254_i) {
            if (!(block == this.inTile && block.func_176201_c(iblockstate) == this.inData || this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05)))) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                }
            }
            ++this.field_184552_b;
        } else {
            Entity entity;
            this.field_184552_b = 0;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
            }
            if (this.func_70241_g()) {
                for (int k = 0; k < 4; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float hVelocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)hVelocity) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float motionMultiplier = 0.99f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                if (this.getArrowType() != 0 || this.getArrowType() != 1) {
                    motionMultiplier = 0.6f;
                }
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)motionMultiplier;
            this.field_70181_x *= (double)motionMultiplier;
            this.field_70179_y *= (double)motionMultiplier;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.05;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70030_z() {
        if (this.getArrowType() == 1) {
            this.field_70178_ae = true;
        }
        super.func_70030_z();
    }

    protected float computeTotalDamage() {
        float motionMagnitude = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        int baseDamage = MathHelper.func_76143_f((double)((double)motionMagnitude * this.func_70242_d()));
        if (this.func_70241_g()) {
            baseDamage += this.field_70146_Z.nextInt(baseDamage / 2 + 2);
        }
        double damage = baseDamage;
        switch (this.getArrowType()) {
            case 2: {
                damage *= 1.25;
                break;
            }
            case 3: 
            case 4: {
                damage *= 0.8;
            }
        }
        return (float)damage;
    }

    protected DamageSource getDamageSource() {
        EntityPrimalArrow shooter = this.field_70250_c == null ? this : this.field_70250_c;
        EntityDamageSourceIndirect damageSource = new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)shooter);
        switch (this.getArrowType()) {
            case 2: {
                damageSource = damageSource.func_76349_b().func_76361_j();
                break;
            }
            case 5: {
                damageSource = damageSource.func_76349_b().func_76348_h();
                break;
            }
            default: {
                damageSource = damageSource.func_76349_b();
            }
        }
        return damageSource;
    }

    protected int getFireDuration() {
        int duration = 0;
        if (this.func_70027_ad() && this.getArrowType() != 1) {
            duration += 5;
        }
        if (this.getArrowType() == 2) {
            duration += 5;
        }
        return duration;
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            int fireDuration = this.getFireDuration();
            if (fireDuration > 0 && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(fireDuration);
            }
            if (entity.func_70097_a(this.getDamageSource(), this.computeTotalDamage())) {
                if (entity instanceof EntityLivingBase) {
                    float hVelocity;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                    if (this.knockbackStrength > 0 && (hVelocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * 0.6 / (double)hVelocity, 0.1, this.field_70179_y * (double)this.knockbackStrength * 0.6 / (double)hVelocity);
                    }
                    if (this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= -0.1;
                this.field_70181_x *= -0.1;
                this.field_70179_y *= -0.1;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < 0.001) {
                    if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                        this.func_70099_a(this.func_184550_j(), 0.1f);
                    }
                    this.func_70106_y();
                }
            }
        } else {
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.inData = this.inTile.func_176201_c(iblockstate);
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * 0.05;
            this.field_70163_u -= this.field_70181_x / (double)f2 * 0.05;
            this.field_70161_v -= this.field_70179_y / (double)f2 * 0.05;
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        switch (this.getArrowType()) {
            case 1: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 4));
                break;
            }
            case 3: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 4));
                break;
            }
            case 4: {
                living.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200, 2));
            }
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.field_70250_c != null ? this.field_70250_c.func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf data) {
        Entity shooter = this.field_70170_p.func_73045_a(data.readInt());
        if (shooter instanceof EntityLivingBase) {
            this.field_70250_c = (EntityLivingBase)shooter;
        }
    }
}

