/*
 * Decompiled with CFR 0.152.
 */
package mod.icarus.crimsonrevelations.item.armor;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import mod.icarus.crimsonrevelations.NewCrimsonRevelations;
import mod.icarus.crimsonrevelations.config.CRConfig;
import mod.icarus.crimsonrevelations.init.CRItems;
import mod.icarus.crimsonrevelations.init.CRMaterials;
import mod.icarus.crimsonrevelations.init.CRRarities;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.entity.PlayerMovementAbilityManager;
import thecodex6824.thaumicaugmentation.api.item.IArmorReduceFallDamage;

public class CRItemMeteorBoots
extends ItemArmor
implements ISpecialArmor,
IRechargable,
IVisDiscountGear,
IArmorReduceFallDamage {
    protected static final String TEXTURE_PATH = new ResourceLocation("crimsonrevelations", "textures/models/armor/meteor_boots.png").toString();
    protected static final BiFunction<EntityPlayer, PlayerMovementAbilityManager.MovementType, Float> MOVEMENT_FUNC = new BiFunction<EntityPlayer, PlayerMovementAbilityManager.MovementType, Float>(){

        @Override
        public Float apply(EntityPlayer player, PlayerMovementAbilityManager.MovementType type) {
            switch (type) {
                case DRY_GROUND: {
                    float boost = (float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_LAND_SPEED;
                    return Float.valueOf(player.func_70093_af() ? boost / 4.0f : boost);
                }
                case JUMP_BEGIN: {
                    return Float.valueOf((float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_JUMP_BOOST);
                }
                case JUMP_FACTOR: {
                    return Float.valueOf((float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_JUMP_FACTOR);
                }
                case STEP_HEIGHT: {
                    return Float.valueOf(!player.func_70093_af() ? (float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_STEP_HEIGHT : 0.0f);
                }
                case WATER_GROUND: {
                    float boost = Math.max((float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_LAND_SPEED / (float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_SNEAK_REDUCTION, (float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_WATER_SPEED);
                    return Float.valueOf(player.func_70093_af() ? boost / (float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_SNEAK_REDUCTION : boost);
                }
                case WATER_SWIM: {
                    float boost = (float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_WATER_SPEED;
                    return Float.valueOf(player.func_70093_af() ? boost / (float)CRConfig.thaumic_augmentation_settings.METEOR_BOOTS_SNEAK_REDUCTION : boost);
                }
            }
            return Float.valueOf(0.0f);
        }
    };
    protected static final Predicate<EntityPlayer> CONTINUE_FUNC = new Predicate<EntityPlayer>(){

        @Override
        public boolean test(EntityPlayer player) {
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_77973_b() != CRItems.meteorBoots) continue;
                return true;
            }
            return false;
        }
    };

    public CRItemMeteorBoots(EntityEquipmentSlot equipmentSlot) {
        super(CRMaterials.BOOTS_METEOR, 4, equipmentSlot);
    }

    public static boolean getSmashingState(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("isSmashing");
    }

    public static void setSmashingState(ItemStack stack, boolean flag) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("isSmashing", flag);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source != DamageSource.field_76379_h || source != DamageSource.field_190095_e || source != DamageSource.field_76372_a || source != DamageSource.field_76370_b) {
            stack.func_77972_a(damage, entity);
        }
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        return 3;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() - armor.func_77952_i());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return TEXTURE_PATH;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == NewCrimsonRevelations.tabCR || tab == CreativeTabs.field_78027_g) {
            ItemStack base = new ItemStack((Item)this, 1, 0);
            items.add((Object)base);
            ItemStack charged = base.func_77946_l();
            RechargeHelper.rechargeItemBlindly((ItemStack)charged, null, (int)this.getMaxCharge(charged, null));
            items.add((Object)charged);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return CRRarities.RARITY_FIREY;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        boolean hasCharge;
        boolean bl = hasCharge = RechargeHelper.getCharge((ItemStack)stack) > 0;
        if (player.func_70093_af() && !player.field_71075_bZ.field_75100_b && !player.func_184613_cA() && player.field_70143_R > 0.0f && hasCharge && !CRItemMeteorBoots.getSmashingState(stack) && !player.func_184811_cZ().func_185141_a(CRItems.meteorBoots)) {
            CRItemMeteorBoots.setSmashingState(stack, true);
            player.func_184185_a(SoundsTC.rumble, 1.0f, 0.8f + (float)player.func_130014_f_().field_73012_v.nextGaussian() * 0.05f);
            RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)player, (int)2);
        }
        if (CRItemMeteorBoots.getSmashingState(stack) && !player.field_71075_bZ.field_75100_b && !player.func_184613_cA() && hasCharge) {
            player.field_70181_x -= 0.4;
            if (player.field_70173_aa % 4 == 0) {
                player.func_184185_a(SoundsTC.rumble, 0.4f, 3.0f);
            }
            if (!world.field_72995_K) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.FLAME, player.field_70165_t + (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f), player.field_70163_u - 1.5, player.field_70161_v + (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f), 10, 0.0, 0.0, 0.0, 0.2, new int[0]);
            }
            if (player.field_70143_R <= 0.0f && player.field_70122_E) {
                int radius = 4;
                AxisAlignedBB area = new AxisAlignedBB(player.field_70165_t - (double)radius, player.field_70163_u - (double)radius, player.field_70161_v - (double)radius, player.field_70165_t + (double)radius, player.field_70163_u + (double)radius, player.field_70161_v + (double)radius);
                CRItemMeteorBoots.setSmashingState(stack, false);
                for (EntityLivingBase nearbyLivingEntity : world.func_175647_a(EntityLivingBase.class, area, EntitySelectors.field_94557_a)) {
                    if (nearbyLivingEntity == player || nearbyLivingEntity.func_184191_r((Entity)player)) continue;
                    nearbyLivingEntity.func_70015_d(5 + world.field_73012_v.nextInt(5));
                    nearbyLivingEntity.func_70653_a((Entity)player, 1.0f, player.field_70165_t - nearbyLivingEntity.field_70165_t, player.field_70161_v - nearbyLivingEntity.field_70161_v);
                    nearbyLivingEntity.func_70097_a(DamageSource.field_76370_b, 12.0f + (float)world.field_73012_v.nextInt(12));
                }
                if (!world.field_72995_K) {
                    int particleAmount = 40;
                    double particleDistance = 2.0;
                    IBlockState state = world.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v).func_177977_b());
                    int blockId = Block.func_176210_f((IBlockState)state);
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.LAVA, player.field_70165_t, player.field_70163_u, player.field_70161_v, particleAmount, particleDistance, 0.0, particleDistance, 0.0, new int[0]);
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, player.field_70165_t, player.field_70163_u, player.field_70161_v, particleAmount, particleDistance, 0.0, particleDistance, 0.15, new int[0]);
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.BLOCK_DUST, player.field_70165_t, player.field_70163_u, player.field_70161_v, particleAmount * 2, particleDistance, 0.0, particleDistance, 1.0, new int[]{blockId});
                }
                player.func_184185_a(SoundEvents.field_187539_bB, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                player.func_184811_cZ().func_185145_a(CRItems.meteorBoots, 100);
            }
        }
        if (!world.field_72995_K && player.field_70173_aa % 20 == 0) {
            int current = 0;
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("energyRemaining", 3)) {
                current = stack.func_77978_p().func_74762_e("energyRemaining");
            } else if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (current > 0) {
                --current;
            }
            if (current <= 0 && RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)player, (int)2)) {
                current = 60;
            }
            stack.func_77978_p().func_74768_a("energyRemaining", current);
        }
        if (PlayerMovementAbilityManager.isValidSideForMovement((EntityPlayer)player)) {
            boolean apply;
            boolean bl2 = apply = !player.field_71075_bZ.field_75100_b && !player.func_184613_cA() && RechargeHelper.getCharge((ItemStack)stack) > 0;
            if (apply && !PlayerMovementAbilityManager.playerHasAbility((EntityPlayer)player, MOVEMENT_FUNC, CONTINUE_FUNC)) {
                PlayerMovementAbilityManager.put((EntityPlayer)player, MOVEMENT_FUNC, CONTINUE_FUNC);
            } else if (!apply && PlayerMovementAbilityManager.playerHasAbility((EntityPlayer)player, MOVEMENT_FUNC, CONTINUE_FUNC)) {
                PlayerMovementAbilityManager.remove((EntityPlayer)player, MOVEMENT_FUNC, CONTINUE_FUNC);
            }
        }
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase player) {
        return 330;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack stack, EntityLivingBase player) {
        return IRechargable.EnumChargeDisplay.PERIODIC;
    }

    public float getNewFallDamage(ItemStack stack, float origDamage, float distance) {
        if (RechargeHelper.getCharge((ItemStack)stack) > 0) {
            return origDamage / 5.0f - 1.0f;
        }
        return origDamage;
    }
}

