/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.lemonlib.handler.cooldown;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import party.lemons.lemonlib.handler.cooldown.CapabilityCooldownHandler;
import party.lemons.lemonlib.handler.cooldown.CooldownContainer;

public class CooldownCapabilityProvider
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    private final CooldownContainer container;

    public CooldownCapabilityProvider(CooldownContainer cooldownContainer) {
        this.container = cooldownContainer;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityCooldownHandler.CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityCooldownHandler.CAPABILITY) {
            return (T)this.container;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList cooldowns = new NBTTagList();
        Map<String, Integer> entries = this.container.getCooldowns();
        for (Map.Entry<String, Integer> entry : entries.entrySet()) {
            if (entry.getValue() <= 0) continue;
            NBTTagCompound cd = new NBTTagCompound();
            cd.func_74778_a("key", entry.getKey());
            cd.func_74768_a("value", entry.getValue().intValue());
            cooldowns.func_74742_a((NBTBase)cd);
        }
        if (cooldowns.func_74745_c() > 0) {
            tagCompound.func_74782_a("cooldowns", (NBTBase)cooldowns);
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("cooldowns")) {
            NBTTagList cooldowns = nbt.func_150295_c("cooldowns", 10);
            for (int i = 0; i < cooldowns.func_74745_c(); ++i) {
                NBTTagCompound entry = cooldowns.func_150305_b(i);
                this.container.setCooldown(entry.func_74779_i("key"), entry.func_74762_e("value"));
            }
        }
    }
}

