/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.helpers;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import veovismuaddib.mystcraft_info.ModMain;

public class GrammarHelper {
    private static final HashMap<ResourceLocation, List<String>> grammarCache = new HashMap();
    private static final List<String> blacklistedRules = Stream.of("featurelarges0", "featuremediums0", "featuresmalls0").collect(Collectors.toList());

    public static List<String> getGrammarFromSymbol(IAgeSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        ResourceLocation location = symbol.getRegistryName();
        if (grammarCache.containsKey(location)) {
            return grammarCache.get(location);
        }
        ArrayList<String> grammarRules = new ArrayList<String>();
        Collection grammarRuleLocations = ModMain.proxy.grammarApi.getTokensProducingToken(symbol.getRegistryName());
        for (ResourceLocation rule : grammarRuleLocations) {
            if (blacklistedRules.contains(rule.func_110623_a())) continue;
            grammarRules.add(GrammarHelper.getGrammarName(rule));
        }
        grammarCache.put(location, grammarRules);
        return grammarRules;
    }

    private static String getGrammarName(ResourceLocation rule) {
        CharSequence[] name = new String[]{"grammar", rule.func_110624_b(), rule.func_110623_a(), "name"};
        String unlocalizedName = String.join((CharSequence)".", name);
        return ModMain.proxy.localize(unlocalizedName, new Object[0]);
    }
}

