/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.info;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.util.Color;
import java.util.ArrayList;
import java.util.List;
import veovismuaddib.mystcraft_info.ModConfig;
import veovismuaddib.mystcraft_info.ModMain;
import veovismuaddib.mystcraft_info.helpers.ModifierHelper;
import veovismuaddib.mystcraft_info.info.SymbolTooltip;

public class ColorTooltip
extends SymbolTooltip.SymbolTooltipGroup {
    public ColorTooltip() {
        super.setHeader("gui.mystcraft_info.color.header");
        super.add(new PercentColorTooltip());
        super.add(new HexColorTooltip());
    }

    @Override
    public List<String> getTooltip(IAgeSymbol symbol) {
        List<String> tooltip = super.getTooltip(symbol);
        if (!this.isVisible(symbol)) {
            return tooltip;
        }
        Color color = ModifierHelper.getColorFromSymbol(symbol);
        if (color == null) {
            return tooltip;
        }
        return tooltip;
    }

    private static class HexColorTooltip
    extends SymbolTooltip {
        private HexColorTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.color_hex.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.color_hex.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Color color = ModifierHelper.getColorFromSymbol(symbol);
            return color != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Color color = ModifierHelper.getColorFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (color == null) {
                return tooltip;
            }
            tooltip.add(this.DEFAULT_FORMAT + String.format("#%06X", color.asInt()));
            return tooltip;
        }
    }

    private static class PercentColorTooltip
    extends SymbolTooltip {
        private PercentColorTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.color_percent.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.color_percent.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Color color = ModifierHelper.getColorFromSymbol(symbol);
            return color != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Color color = ModifierHelper.getColorFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (color == null) {
                return tooltip;
            }
            tooltip.add(this.DEFAULT_FORMAT + ModMain.proxy.localize("gui.mystcraft_info.color.percent", Math.round(color.r * 100.0f), Math.round(color.g * 100.0f), Math.round(color.b * 100.0f)));
            return tooltip;
        }
    }
}

