/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.info;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import veovismuaddib.mystcraft_info.ModConfig;
import veovismuaddib.mystcraft_info.helpers.ModifierHelper;
import veovismuaddib.mystcraft_info.info.SymbolTooltip;

public class ParentModTooltip
extends SymbolTooltip {
    private static final String FORMAT_STANDARD = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
    private static final String FORMAT_MOD = TextFormatting.RESET.toString() + TextFormatting.BLUE.toString() + TextFormatting.ITALIC.toString();
    private static final String FORMAT_MOD_SYMBOL = TextFormatting.RESET.toString() + TextFormatting.DARK_GREEN.toString() + TextFormatting.ITALIC.toString();

    @Override
    public boolean isEnabled() {
        return ModConfig.tooltips.parent_mod.enabled;
    }

    @Override
    public boolean requiresShift() {
        return ModConfig.tooltips.parent_mod.shift_required;
    }

    private boolean isVerbose() {
        return ModConfig.tooltips.parent_mod.verbose;
    }

    @Override
    public List<String> getTooltip(IAgeSymbol symbol) {
        List<String> tooltip = super.getTooltip(symbol);
        if (!this.isVisible(symbol)) {
            return tooltip;
        }
        String modName = ParentModTooltip.getBlockModName(symbol);
        modName = modName != null ? modName : ParentModTooltip.getBiomeModName(symbol);
        String symbolModName = ParentModTooltip.getSymbolModName(symbol);
        String string = modName = modName != null ? modName : symbolModName;
        if (modName.equals(symbolModName)) {
            this.addSingleModTooltip(tooltip, modName);
        } else {
            this.addMultipleModTooltip(tooltip, modName, symbolModName);
        }
        return tooltip;
    }

    private void addSingleModTooltip(List<String> tooltip, String modName) {
        modName = FORMAT_MOD + modName + FORMAT_STANDARD;
        if (this.isVerbose()) {
            String langKey = "mystcraft_info.tooltips.format.parent_mod_symbol_verbose";
            tooltip.add(FORMAT_STANDARD + I18n.func_135052_a((String)langKey, (Object[])new Object[]{modName}));
        } else {
            String langKey = "mystcraft_info.tooltips.format.parent_mod";
            tooltip.add(FORMAT_STANDARD + I18n.func_135052_a((String)langKey, (Object[])new Object[]{modName}));
        }
    }

    private void addMultipleModTooltip(List<String> tooltip, String modName, String symbolModName) {
        modName = FORMAT_MOD + modName + FORMAT_STANDARD;
        symbolModName = FORMAT_MOD_SYMBOL + symbolModName + FORMAT_STANDARD;
        if (this.isVerbose()) {
            String contentLangKey = "mystcraft_info.tooltips.format.parent_mod_content_verbose";
            String symbolLangKey = "mystcraft_info.tooltips.format.parent_mod_symbol_verbose";
            tooltip.add(FORMAT_STANDARD + I18n.func_135052_a((String)contentLangKey, (Object[])new Object[]{modName, modName}));
            tooltip.add(FORMAT_STANDARD + I18n.func_135052_a((String)symbolLangKey, (Object[])new Object[]{symbolModName, modName}));
        } else {
            String multipleLangKey = "mystcraft_info.tooltips.format.parent_mod_multiple";
            tooltip.add(FORMAT_STANDARD + I18n.func_135052_a((String)multipleLangKey, (Object[])new Object[]{symbolModName, modName}));
        }
    }

    private static String resourceDomainToModName(String modId) {
        String modName = null;
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals(modId)) continue;
            modName = mod.getName();
            break;
        }
        return modName;
    }

    private static String getSymbolModName(IAgeSymbol symbol) {
        String modId = symbol.getRegistryName().func_110624_b();
        return ParentModTooltip.resourceDomainToModName(modId);
    }

    private static String getBiomeModName(IAgeSymbol symbol) {
        Biome biome = ModifierHelper.getBiomeFromSymbol(symbol);
        String modId = "";
        if (biome != null) {
            modId = ModifierHelper.getBiomeFromSymbol(symbol).getRegistryName().func_110624_b();
        }
        return ParentModTooltip.resourceDomainToModName(modId);
    }

    private static String getBlockModName(IAgeSymbol symbol) {
        IBlockState state = ModifierHelper.getBlockStateFromSymbol(symbol);
        String modId = "";
        if (state != null) {
            modId = ModifierHelper.getBlockStateFromSymbol(symbol).func_177230_c().getRegistryName().func_110624_b();
        }
        return ParentModTooltip.resourceDomainToModName(modId);
    }
}

