/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.info;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.ArrayList;
import java.util.List;
import veovismuaddib.mystcraft_info.ModConfig;
import veovismuaddib.mystcraft_info.helpers.ModifierHelper;
import veovismuaddib.mystcraft_info.info.SymbolTooltip;

public class PhaseTooltip
extends SymbolTooltip.SymbolTooltipGroup {
    public PhaseTooltip() {
        super.setHeader("gui.mystcraft_info.phase.header");
        super.add(new PercentPhaseTooltip());
        super.add(new DegreePhaseTooltip());
    }

    @Override
    public List<String> getTooltip(IAgeSymbol symbol) {
        List<String> tooltip = super.getTooltip(symbol);
        if (!this.isVisible(symbol)) {
            return tooltip;
        }
        Number phase = ModifierHelper.getPhaseFromSymbol(symbol);
        if (phase == null) {
            return tooltip;
        }
        return tooltip;
    }

    private static class DegreePhaseTooltip
    extends SymbolTooltip {
        private DegreePhaseTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.phase_degrees.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.phase_degrees.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Number phase = ModifierHelper.getPhaseFromSymbol(symbol);
            return phase != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Number phase = ModifierHelper.getPhaseFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (phase == null) {
                return tooltip;
            }
            tooltip.add(this.DEFAULT_FORMAT + String.format("%.1f\u00c2\u00b0", Float.valueOf(phase.floatValue())));
            return tooltip;
        }
    }

    private static class PercentPhaseTooltip
    extends SymbolTooltip {
        private PercentPhaseTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.phase_percent.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.phase_percent.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Number phase = ModifierHelper.getPhaseFromSymbol(symbol);
            return phase != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Number phase = ModifierHelper.getPhaseFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (phase == null) {
                return tooltip;
            }
            float percentagePhase = phase.floatValue() / 360.0f % 1.0f;
            tooltip.add(this.DEFAULT_FORMAT + String.format("%d%%", Math.round(percentagePhase * 100.0f)));
            return tooltip;
        }
    }
}

