/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.info;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;
import veovismuaddib.mystcraft_info.ModMain;

public abstract class SymbolTooltip {
    protected final String INDENT = "  ";
    protected final String DEFAULT_FORMAT = "  " + TextFormatting.GRAY.toString();
    protected final String HEADER_FORMAT = TextFormatting.BLUE.toString() + TextFormatting.BOLD.toString();
    private String HEADER = null;
    private boolean leadingNewline = true;

    public abstract boolean isEnabled();

    public abstract boolean requiresShift();

    public boolean isVisible(IAgeSymbol symbol) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.isRelevant(symbol)) {
            return false;
        }
        return !this.requiresShift() || GuiScreen.func_146272_n();
    }

    public boolean isRelevant(IAgeSymbol symbol) {
        return true;
    }

    public void setLeadingNewline(boolean enabled) {
        this.leadingNewline = enabled;
    }

    public void setHeader(String unlocalizedHeader) {
        this.HEADER = ModMain.proxy.localize(unlocalizedHeader, new Object[0]);
    }

    public List<String> getTooltip(IAgeSymbol symbol) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (!this.isVisible(symbol)) {
            return tooltip;
        }
        if (this.leadingNewline) {
            tooltip.add("");
        }
        if (this.HEADER != null) {
            tooltip.add(this.HEADER_FORMAT + this.HEADER);
        }
        return tooltip;
    }

    public static abstract class SymbolTooltipGroup
    extends SymbolTooltip {
        private final List<SymbolTooltip> children = new ArrayList<SymbolTooltip>();

        public void add(SymbolTooltip child) {
            this.children.add(child);
        }

        @Override
        public boolean isEnabled() {
            for (SymbolTooltip child : this.children) {
                if (!child.isEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean requiresShift() {
            for (SymbolTooltip child : this.children) {
                if (!child.isEnabled() || !child.requiresShift()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            if (!this.isEnabled()) {
                return false;
            }
            for (SymbolTooltip child : this.children) {
                if (!child.isRelevant(symbol)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isVisible(IAgeSymbol symbol) {
            for (SymbolTooltip child : this.children) {
                if (!child.isVisible(symbol)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            List<String> tooltip = super.getTooltip(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            for (SymbolTooltip child : this.children) {
                tooltip.addAll(child.getTooltip(symbol));
            }
            return tooltip;
        }
    }
}

