/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.proxy;

import com.xcompwiz.mystcraft.api.MystObjects;
import com.xcompwiz.mystcraft.api.exception.APIUndefined;
import com.xcompwiz.mystcraft.api.exception.APIVersionRemoved;
import com.xcompwiz.mystcraft.api.exception.APIVersionUndefined;
import com.xcompwiz.mystcraft.api.hook.GrammarAPI;
import com.xcompwiz.mystcraft.api.hook.PageAPI;
import com.xcompwiz.mystcraft.api.hook.SymbolAPI;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import veovismuaddib.mystcraft_info.ModMain;
import veovismuaddib.mystcraft_info.info.ColorTooltip;
import veovismuaddib.mystcraft_info.info.DirectionTooltip;
import veovismuaddib.mystcraft_info.info.GrammarTooltip;
import veovismuaddib.mystcraft_info.info.LengthTooltip;
import veovismuaddib.mystcraft_info.info.ParentModTooltip;
import veovismuaddib.mystcraft_info.info.PhaseTooltip;
import veovismuaddib.mystcraft_info.info.PoemTooltip;
import veovismuaddib.mystcraft_info.listeners.PageTooltipListener;

@Mod.EventBusSubscriber
public class CommonProxy {
    public PageAPI pageApi;
    public SymbolAPI symbolApi;
    public GrammarAPI grammarApi;
    public IForgeRegistry<IAgeSymbol> symbolRegistry;

    public void preInit(FMLPreInitializationEvent e) {
    }

    public void init(FMLInitializationEvent e) {
        try {
            ModMain.logger.info("Initializing Mystcraft APIs");
            this.pageApi = (PageAPI)MystObjects.entryPoint.getProviderInstance().getAPIInstance("page-1");
            this.symbolApi = (SymbolAPI)MystObjects.entryPoint.getProviderInstance().getAPIInstance("symbol-1");
            this.grammarApi = (GrammarAPI)MystObjects.entryPoint.getProviderInstance().getAPIInstance("grammar-1");
            this.symbolRegistry = GameRegistry.findRegistry(IAgeSymbol.class);
            ModMain.logger.info("Successfully initialized Mystcraft APIs");
        }
        catch (APIVersionRemoved e1) {
            ModMain.logger.error("API version removed!");
        }
        catch (APIVersionUndefined e2) {
            ModMain.logger.error("API version undefined!");
        }
        catch (APIUndefined e3) {
            ModMain.logger.error("API undefined!");
        }
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.registerTooltipListener();
    }

    public String localize(String unlocalizedString, Object ... parameters) {
        return I18n.func_135052_a((String)unlocalizedString, (Object[])parameters);
    }

    protected void registerTooltipListener() {
        PageTooltipListener tooltipListener = new PageTooltipListener();
        tooltipListener.addTooltip(new PoemTooltip());
        tooltipListener.addTooltip(new GrammarTooltip());
        tooltipListener.addTooltip(new ColorTooltip());
        tooltipListener.addTooltip(new LengthTooltip());
        tooltipListener.addTooltip(new DirectionTooltip());
        tooltipListener.addTooltip(new PhaseTooltip());
        tooltipListener.addTooltip(new ParentModTooltip());
        MinecraftForge.EVENT_BUS.register((Object)tooltipListener);
    }
}

