/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.renderer.chunk;

import java.util.List;
import meldexun.nothirium.api.renderer.IVBOPart;
import meldexun.nothirium.api.renderer.chunk.ChunkRenderPass;
import meldexun.nothirium.mc.config.NothiriumConfig;
import meldexun.nothirium.mc.renderer.chunk.ChunkRendererDynamicVbo;
import meldexun.nothirium.mc.renderer.chunk.RenderChunk;
import meldexun.nothirium.opengl.DynamicVBO;
import meldexun.nothirium.util.ListUtil;
import meldexun.renderlib.util.RenderUtil;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;

public class ChunkRendererGL15
extends ChunkRendererDynamicVbo {
    @Override
    public NothiriumConfig.RenderEngine getRenderEngine() {
        return NothiriumConfig.RenderEngine.GL15;
    }

    @Override
    public String name() {
        return "Nothirium GL 1.5";
    }

    @Override
    public void init(int renderDistance) {
    }

    @Override
    protected void renderChunks(ChunkRenderPass pass) {
        GL15.glBindBuffer((int)34962, (int)((DynamicVBO)this.vbos.get(pass)).getVbo());
        this.setupClientState(pass);
        this.setupAttributePointers(pass);
        double cameraX = RenderUtil.getCameraEntityX();
        double cameraY = RenderUtil.getCameraEntityY();
        double cameraZ = RenderUtil.getCameraEntityZ();
        ListUtil.forEach((List)this.chunks.get(pass), pass == ChunkRenderPass.TRANSLUCENT, (renderChunk, i) -> this.draw((RenderChunk)renderChunk, pass, cameraX, cameraY, cameraZ));
        this.resetClientState(pass);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    protected void setupClientState(ChunkRenderPass pass) {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
        GL11.glEnableClientState((int)32888);
        GL13.glClientActiveTexture((int)33985);
        GL11.glEnableClientState((int)32888);
        GL13.glClientActiveTexture((int)33984);
    }

    protected void setupAttributePointers(ChunkRenderPass pass) {
        GL11.glVertexPointer((int)3, (int)5126, (int)28, (long)0L);
        GL11.glColorPointer((int)4, (int)5121, (int)28, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)28, (long)16L);
        GL13.glClientActiveTexture((int)33985);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)28, (long)24L);
        GL13.glClientActiveTexture((int)33984);
    }

    protected void draw(RenderChunk renderChunk, ChunkRenderPass pass, double cameraX, double cameraY, double cameraZ) {
        IVBOPart vboPart = renderChunk.getVBOPart(pass);
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)renderChunk.getX() - cameraX), (double)((double)renderChunk.getY() - cameraY), (double)((double)renderChunk.getZ() - cameraZ));
        GL11.glDrawArrays((int)7, (int)vboPart.getFirst(), (int)vboPart.getCount());
        GL11.glPopMatrix();
    }

    protected void resetClientState(ChunkRenderPass pass) {
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32888);
        GL13.glClientActiveTexture((int)33985);
        GL11.glDisableClientState((int)32888);
        GL13.glClientActiveTexture((int)33984);
    }
}

