/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.renderer.chunk;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.IntStream;
import meldexun.memoryutil.NIOBufferUtil;
import meldexun.nothirium.api.renderer.chunk.ChunkRenderPass;
import meldexun.nothirium.api.renderer.chunk.IChunkRenderer;
import meldexun.nothirium.api.renderer.chunk.IRenderChunkDispatcher;
import meldexun.nothirium.api.renderer.chunk.RenderChunkTaskResult;
import meldexun.nothirium.mc.renderer.chunk.RenderChunk;
import meldexun.nothirium.mc.renderer.chunk.SectionRenderCache;
import meldexun.nothirium.mc.util.BlockRenderLayerUtil;
import meldexun.nothirium.mc.util.EnumFacingUtil;
import meldexun.nothirium.renderer.chunk.AbstractRenderChunkTask;
import meldexun.nothirium.util.Direction;
import meldexun.nothirium.util.VertexSortUtil;
import meldexun.nothirium.util.VisibilityGraph;
import meldexun.nothirium.util.VisibilitySet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;

public class RenderChunkTaskCompile
extends AbstractRenderChunkTask<RenderChunk> {
    private static final BlockingQueue<RegionRenderCacheBuilder> BUFFER_QUEUE = new LinkedBlockingQueue<RegionRenderCacheBuilder>();
    private final IBlockAccess chunkCache;

    public RenderChunkTaskCompile(IChunkRenderer<?> chunkRenderer, IRenderChunkDispatcher taskDispatcher, RenderChunk renderChunk, IBlockAccess chunkCache) {
        super(chunkRenderer, taskDispatcher, renderChunk);
        this.chunkCache = chunkCache;
    }

    private static void freeBuffer(RegionRenderCacheBuilder buffer) {
        for (BlockRenderLayer layer : BlockRenderLayerUtil.ALL) {
            BufferBuilder bufferBuilder = buffer.func_179038_a(layer);
            if (bufferBuilder.field_179010_r) {
                bufferBuilder.func_178977_d();
            }
            bufferBuilder.func_178965_a();
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
        }
        BUFFER_QUEUE.add(buffer);
    }

    @Override
    public RenderChunkTaskResult run() {
        if (this.chunkCache instanceof SectionRenderCache) {
            ((SectionRenderCache)this.chunkCache).initCaches();
        }
        try {
            RenderChunkTaskResult renderChunkTaskResult = this.compileSection();
            return renderChunkTaskResult;
        }
        finally {
            if (this.chunkCache instanceof SectionRenderCache) {
                ((SectionRenderCache)this.chunkCache).freeCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderChunkTaskResult compileSection() {
        RegionRenderCacheBuilder bufferBuilderPack = null;
        boolean freeBufferBuilderPack = true;
        try {
            bufferBuilderPack = BUFFER_QUEUE.take();
            freeBufferBuilderPack = this.compileSection(bufferBuilderPack) != RenderChunkTaskResult.SUCCESSFUL;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            RenderChunkTaskResult renderChunkTaskResult = RenderChunkTaskResult.CANCELLED;
            return renderChunkTaskResult;
        }
        finally {
            if (bufferBuilderPack != null && freeBufferBuilderPack) {
                RenderChunkTaskCompile.freeBuffer(bufferBuilderPack);
            }
        }
        return this.canceled() ? RenderChunkTaskResult.CANCELLED : RenderChunkTaskResult.SUCCESSFUL;
    }

    private RenderChunkTaskResult compileSection(RegionRenderCacheBuilder bufferBuilderPack) {
        Entity entity;
        if (this.canceled()) {
            return RenderChunkTaskResult.CANCELLED;
        }
        Minecraft mc = Minecraft.func_71410_x();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        VisibilityGraph visibilityGraph = new VisibilityGraph();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    pos.func_181079_c(((RenderChunk)this.renderChunk).getX() + x, ((RenderChunk)this.renderChunk).getY() + y, ((RenderChunk)this.renderChunk).getZ() + z);
                    IBlockState blockState = this.chunkCache.func_180495_p((BlockPos)pos);
                    this.renderBlockState(blockState, (BlockPos)pos, visibilityGraph, bufferBuilderPack);
                }
            }
            if (!this.canceled()) continue;
            return RenderChunkTaskResult.CANCELLED;
        }
        VisibilitySet visibilitySet = visibilityGraph.compute();
        if (bufferBuilderPack.func_179038_a((BlockRenderLayer)BlockRenderLayer.TRANSLUCENT).field_179010_r && (entity = mc.func_175606_aa()) != null) {
            BufferBuilder bufferBuilder2 = bufferBuilderPack.func_179038_a(BlockRenderLayer.TRANSLUCENT);
            Vec3d camera = entity.func_174824_e(1.0f);
            VertexSortUtil.sortVertexData(NIOBufferUtil.asMemoryAccess((Buffer)bufferBuilder2.func_178966_f()), bufferBuilder2.func_178989_h(), bufferBuilder2.func_178973_g().func_177338_f(), 4, (float)((double)((RenderChunk)this.renderChunk).getX() - camera.field_72450_a), (float)((double)((RenderChunk)this.renderChunk).getY() - camera.field_72448_b), (float)((double)((RenderChunk)this.renderChunk).getZ() - camera.field_72449_c));
        }
        if (this.canceled()) {
            return RenderChunkTaskResult.CANCELLED;
        }
        BufferBuilder[] finishedBufferBuilders = (BufferBuilder[])Arrays.stream(BlockRenderLayerUtil.ALL).map(arg_0 -> ((RegionRenderCacheBuilder)bufferBuilderPack).func_179038_a(arg_0)).map(bufferBuilder -> {
            if (!bufferBuilder.field_179010_r) {
                return null;
            }
            bufferBuilder.func_178977_d();
            if (bufferBuilder.func_178989_h() == 0) {
                return null;
            }
            return bufferBuilder;
        }).toArray(BufferBuilder[]::new);
        if (this.canceled()) {
            return RenderChunkTaskResult.CANCELLED;
        }
        this.taskDispatcher.runOnRenderThread(() -> {
            try {
                if (!this.canceled()) {
                    ((RenderChunk)this.renderChunk).setVisibility(visibilitySet);
                    for (ChunkRenderPass pass : ChunkRenderPass.ALL) {
                        BufferBuilder bufferBuilder = finishedBufferBuilders[pass.ordinal()];
                        if (bufferBuilder == null) {
                            ((RenderChunk)this.renderChunk).setVBOPart(pass, null);
                            continue;
                        }
                        ((RenderChunk)this.renderChunk).setVBOPart(pass, this.chunkRenderer.buffer(pass, bufferBuilder.func_178966_f()));
                        if (pass != ChunkRenderPass.TRANSLUCENT) continue;
                        ((RenderChunk)this.renderChunk).setTranslucentVertexData(NIOBufferUtil.copyAsUnsafeBuffer((ByteBuffer)bufferBuilder.func_178966_f()));
                    }
                }
            }
            finally {
                RenderChunkTaskCompile.freeBuffer(bufferBuilderPack);
            }
        });
        return RenderChunkTaskResult.SUCCESSFUL;
    }

    public void renderBlockState(IBlockState blockState, BlockPos pos, VisibilityGraph visibilityGraph, RegionRenderCacheBuilder bufferBuilderPack) {
        if (blockState.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
            return;
        }
        for (Direction direction : Direction.ALL) {
            if (!blockState.doesSideBlockRendering(this.chunkCache, pos, EnumFacingUtil.getFacing(direction))) continue;
            visibilityGraph.setOpaque(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), direction);
        }
        for (Direction direction : BlockRenderLayerUtil.ALL) {
            if (!blockState.func_177230_c().canRenderInLayer(blockState, (BlockRenderLayer)direction)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)direction);
            BufferBuilder bufferBuilder = bufferBuilderPack.func_179038_a((BlockRenderLayer)direction);
            if (!bufferBuilder.field_179010_r) {
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                bufferBuilder.func_178969_c((double)(-((RenderChunk)this.renderChunk).getX()), (double)(-((RenderChunk)this.renderChunk).getY()), (double)(-((RenderChunk)this.renderChunk).getZ()));
            }
            Minecraft.func_71410_x().func_175602_ab().func_175018_a(blockState, pos, this.chunkCache, bufferBuilder);
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    static {
        IntStream.range(0, (Runtime.getRuntime().availableProcessors() - 2) * 2).mapToObj(i -> new RegionRenderCacheBuilder()).forEach(BUFFER_QUEUE::add);
    }
}

