/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.util;

import meldexun.memoryutil.UnsafeFloatBuffer;
import meldexun.nothirium.util.math.MathUtil;
import meldexun.renderlib.util.GLShader;
import meldexun.renderlib.util.GLUtil;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class FogUtil {
    public static final int CYLINDRICAL_FOG = 0;
    public static final int SPHERICAL_FOG = 1;
    public static final int LINEAR_FOG = 0;
    public static final int EXP_FOG = 1;
    public static final int EXP2_FOG = 2;
    private static final String U_FOGENABLED = "u_FogEnabled";
    private static final String U_FOGSHAPE = "u_FogShape";
    private static final String U_FOGMODE = "u_FogMode";
    private static final String U_FOGSTART = "u_FogStart";
    private static final String U_FOGEND = "u_FogEnd";
    private static final String U_FOGDENSITY = "u_FogDensity";
    private static final String U_FOGCOLOR = "u_FogColor";
    private static final double FOG_THRESHOLD = -Math.log(0.001);

    public static void setupFogFromGL(GLShader shader) {
        if (!GL11.glGetBoolean((int)2912)) {
            GL20.glUniform1i((int)shader.getUniform(U_FOGENABLED), (int)0);
        } else {
            GL20.glUniform1i((int)shader.getUniform(U_FOGENABLED), (int)1);
            GL20.glUniform1i((int)shader.getUniform(U_FOGSHAPE), (int)0);
            int fogMode = GL11.glGetInteger((int)2917);
            if (fogMode == 9729) {
                GL20.glUniform1i((int)shader.getUniform(U_FOGMODE), (int)0);
                GL20.glUniform1f((int)shader.getUniform(U_FOGSTART), (float)GL11.glGetFloat((int)2915));
                GL20.glUniform1f((int)shader.getUniform(U_FOGEND), (float)GL11.glGetFloat((int)2916));
            } else if (fogMode == 2048) {
                GL20.glUniform1i((int)shader.getUniform(U_FOGMODE), (int)1);
                GL20.glUniform1f((int)shader.getUniform(U_FOGDENSITY), (float)GL11.glGetFloat((int)2914));
            } else if (fogMode == 2049) {
                GL20.glUniform1i((int)shader.getUniform(U_FOGMODE), (int)2);
                GL20.glUniform1f((int)shader.getUniform(U_FOGDENSITY), (float)GL11.glGetFloat((int)2914));
            }
            UnsafeFloatBuffer fogColor = GLUtil.getFloat((int)2918);
            GL20.glUniform4f((int)shader.getUniform(U_FOGCOLOR), (float)fogColor.getFloat(0L), (float)fogColor.getFloat(4L), (float)fogColor.getFloat(8L), (float)fogColor.getFloat(12L));
        }
    }

    public static double calculateFogEndSqr() {
        if (!GL11.glGetBoolean((int)2912)) {
            return Double.MAX_VALUE;
        }
        int fogMode = GL11.glGetInteger((int)2917);
        if (fogMode == 9729) {
            return MathUtil.square(GL11.glGetFloat((int)2916));
        }
        if (fogMode == 2048) {
            return MathUtil.square(FOG_THRESHOLD / (double)GL11.glGetFloat((int)2914));
        }
        if (fogMode == 2049) {
            return FOG_THRESHOLD / MathUtil.square(GL11.glGetFloat((int)2914));
        }
        return Double.MAX_VALUE;
    }
}

