/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongComparators;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FPSAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DecimalFormat FORMAT = new DecimalFormat("####0.0");
    private static long[] FRAME_TIMES = new long[1000];
    private static int maxFrameCount = 10;
    private static int counter;
    private static long t;

    public static void start() {
        t = System.nanoTime();
    }

    public static void end() {
        int n = counter;
        FRAME_TIMES[n] = FRAME_TIMES[n] + (System.nanoTime() - t);
    }

    public static void print() {
        if (counter % FRAME_TIMES.length == 0) {
            double avg = Arrays.stream(FRAME_TIMES).average().getAsDouble();
            LongArrayList maxes = new LongArrayList(maxFrameCount);
            Arrays.stream(FRAME_TIMES).forEach(t -> {
                if (maxes.size() < maxFrameCount) {
                    maxes.add(t);
                    maxes.sort((Comparator)LongComparators.OPPOSITE_COMPARATOR);
                } else if (maxes.getLong(maxes.size() - 1) < t) {
                    maxes.set(maxes.size() - 1, t);
                    maxes.sort((Comparator)LongComparators.OPPOSITE_COMPARATOR);
                }
            });
            double maxesAvg = 0.0;
            LongListIterator iter = maxes.iterator();
            while (iter.hasNext()) {
                maxesAvg += (double)iter.nextLong();
            }
            maxesAvg /= (double)maxes.size();
            StringBuilder sb = new StringBuilder();
            sb.append("avg=");
            FPSAnalyzer.add(sb, avg);
            sb.append("    maxesAvg=");
            FPSAnalyzer.add(sb, maxesAvg);
            sb.append("    maxes=[");
            sb.append(' ');
            LongListIterator longListIterator = maxes.iterator();
            while (longListIterator.hasNext()) {
                long l = (Long)longListIterator.next();
                FPSAnalyzer.add(sb, l);
                sb.append(' ');
            }
            sb.append(']');
            LOGGER.info((CharSequence)sb);
        }
        counter = (counter + 1) % FRAME_TIMES.length;
        FPSAnalyzer.FRAME_TIMES[FPSAnalyzer.counter] = 0L;
    }

    private static void add(StringBuilder sb, double t) {
        String s = FORMAT.format(t / 1000.0);
        for (int i = s.length(); i < 7; ++i) {
            sb.append(' ');
        }
        sb.append(s);
    }
}

