/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.stream.IntStream;
import meldexun.nothirium.util.Direction;
import meldexun.nothirium.util.VisibilitySet;
import meldexun.nothirium.util.collection.Enum2ObjMap;

public class VisibilityGraph {
    private static final int DX = 256;
    private static final int DY = 16;
    private static final int DZ = 1;
    private static final Enum2ObjMap<Direction, int[]> INDICES = new Enum2ObjMap<Direction, int[]>(Direction.class, dir -> {
        switch (dir) {
            case DOWN: {
                return IntStream.range(0, 16).flatMap(i -> IntStream.range(0, 16).map(j -> VisibilityGraph.index(i, 0, j))).toArray();
            }
            case UP: {
                return IntStream.range(0, 16).flatMap(i -> IntStream.range(0, 16).map(j -> VisibilityGraph.index(i, 15, j))).toArray();
            }
            case NORTH: {
                return IntStream.range(0, 16).flatMap(i -> IntStream.range(0, 16).map(j -> VisibilityGraph.index(i, j, 0))).toArray();
            }
            case SOUTH: {
                return IntStream.range(0, 16).flatMap(i -> IntStream.range(0, 16).map(j -> VisibilityGraph.index(i, j, 15))).toArray();
            }
            case WEST: {
                return IntStream.range(0, 16).flatMap(i -> IntStream.range(0, 16).map(j -> VisibilityGraph.index(0, i, j))).toArray();
            }
            case EAST: {
                return IntStream.range(0, 16).flatMap(i -> IntStream.range(0, 16).map(j -> VisibilityGraph.index(15, i, j))).toArray();
            }
        }
        throw new IllegalArgumentException();
    });
    private final BitSet opacityCache = new BitSet(24576);
    private int opaqueFaceCount;

    public void setOpaque(int x, int y, int z, Direction dir) {
        this.opacityCache.set(VisibilityGraph.indexExt(x & 0xF, y & 0xF, z & 0xF, dir));
        ++this.opaqueFaceCount;
    }

    private static int indexExt(int x, int y, int z, Direction dir) {
        return VisibilityGraph.indexExt(VisibilityGraph.index(x, y, z), dir);
    }

    private static int indexExt(int index, Direction dir) {
        return index | dir.ordinal() << 12;
    }

    private static int index(int x, int y, int z) {
        return x << 8 | y << 4 | z;
    }

    private static int x(int index) {
        return index >> 8 & 0xF;
    }

    private static int y(int index) {
        return index >> 4 & 0xF;
    }

    private static int z(int index) {
        return index & 0xF;
    }

    public VisibilitySet compute() {
        VisibilitySet visibilitySet = new VisibilitySet();
        if (this.opaqueFaceCount < 256) {
            visibilitySet.setAllVisible();
        } else if (this.opaqueFaceCount < 24575) {
            BitSet visited = new BitSet(4096);
            for (Direction dir : Direction.ALL) {
                for (int index : INDICES.get(dir)) {
                    this.traverse(visibilitySet, visited, index, dir);
                    if (!visibilitySet.allVisible()) continue;
                    return visibilitySet;
                }
            }
        }
        return visibilitySet;
    }

    private void traverse(VisibilitySet visibilitySet, BitSet visited, int startIndex, Direction origin) {
        if (this.opacityCache.get(VisibilityGraph.indexExt(startIndex, origin))) {
            return;
        }
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        queue.enqueue(startIndex);
        EnumSet<Direction> visibles = EnumSet.noneOf(Direction.class);
        while (!queue.isEmpty()) {
            int index = queue.dequeueInt();
            for (Direction dir : Direction.ALL) {
                if (this.opacityCache.get(VisibilityGraph.indexExt(index, dir))) continue;
                int neighborIndex = this.neighbor(index, dir);
                if (neighborIndex < 0) {
                    visibles.add(dir);
                    continue;
                }
                if (this.opacityCache.get(VisibilityGraph.indexExt(neighborIndex, dir.opposite())) || visited.get(neighborIndex)) continue;
                visited.set(neighborIndex);
                queue.enqueue(neighborIndex);
            }
            if (visibles.size() != Direction.ALL.length) continue;
            visibilitySet.setAllVisible();
            return;
        }
        for (Direction dir1 : visibles) {
            for (Direction dir2 : visibles) {
                visibilitySet.setVisible(dir1, dir2);
            }
        }
    }

    private int neighbor(int index, Direction dir) {
        switch (dir) {
            case DOWN: {
                if (VisibilityGraph.y(index) == 0) {
                    return -1;
                }
                return index - 16;
            }
            case UP: {
                if (VisibilityGraph.y(index) == 15) {
                    return -1;
                }
                return index + 16;
            }
            case NORTH: {
                if (VisibilityGraph.z(index) == 0) {
                    return -1;
                }
                return index - 1;
            }
            case SOUTH: {
                if (VisibilityGraph.z(index) == 15) {
                    return -1;
                }
                return index + 1;
            }
            case WEST: {
                if (VisibilityGraph.x(index) == 0) {
                    return -1;
                }
                return index - 256;
            }
            case EAST: {
                if (VisibilityGraph.x(index) == 15) {
                    return -1;
                }
                return index + 256;
            }
        }
        return -1;
    }
}

