/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.cache;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.IntFunction;

public class ArrayCache<T> {
    private final Queue<T[]> cache = new LinkedList<T[]>();
    private final int arraySize;
    private final IntFunction<T[]> supplier;
    private final T filler;

    public ArrayCache(int arraySize, IntFunction<T[]> supplier, T filler) {
        this.arraySize = arraySize;
        this.supplier = supplier;
        this.filler = filler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] get() {
        T[] a;
        ArrayCache arrayCache = this;
        synchronized (arrayCache) {
            a = this.cache.poll();
        }
        if (a == null) {
            a = this.supplier.apply(this.arraySize);
            Arrays.fill(a, this.filler);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(T[] t) {
        Arrays.fill(t, this.filler);
        ArrayCache arrayCache = this;
        synchronized (arrayCache) {
            this.cache.add(t);
        }
    }
}

